/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.project.IProjectRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class NewProjectWizardModel
extends ObservableUIPojo {
    public static final String PROPERTY_PROJECT_NAME = "projectName";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    private String description;
    private String displayName;
    private String projectName;
    private Connection connection;
    private List<IProject> projects;
    private IProject project;

    protected NewProjectWizardModel(Connection connection, List<IProject> projects) {
        this.connection = connection;
        this.projects = projects;
    }

    public IProject createProject() {
        if (this.connection == null) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Could not create project, missing connection.");
            return null;
        }
        IProjectRequest request = (IProjectRequest)this.connection.getResourceFactory().stub("ProjectRequest", this.getProjectName());
        request.setDescription(this.getDescription());
        request.setDisplayName(this.getDisplayName());
        IProject project = (IProject)this.connection.createResource((IResource)request);
        ArrayList<IProject> newProjects = new ArrayList<IProject>(this.projects);
        newProjects.add((IProject)this.connection.getResource((IResource)project));
        ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)this.connection, "openshift.projects", this.projects, Collections.unmodifiableList(newProjects));
        this.project = project;
        return this.project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.firePropertyChange(PROPERTY_PROJECT_NAME, this.projectName, this.projectName);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.firePropertyChange(PROPERTY_DESCRIPTION, this.description, this.description);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.firePropertyChange(PROPERTY_DISPLAY_NAME, this.displayName, this.displayName);
    }

    public IProject getProject() {
        return this.project;
    }
}

