/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizardPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class ManageProjectsWizardPage
extends AbstractOpenShiftWizardPage {
    private static final IPluginLog LOG = OpenShiftUIActivator.getDefault().getLogger();
    private ManageProjectsWizardPageModel pageModel;
    private TableViewer viewer;

    public ManageProjectsWizardPage(String title, String description, ManageProjectsWizardPageModel pageModel, IWizard wizard) {
        super(title, description, title, wizard);
        this.pageModel = pageModel;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group group = new Group(parent, 0);
        group.setText("OpenShift Projects");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)group);
        Composite tableContainer = new Composite((Composite)group, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setInput((Object)BeanProperties.list((String)"projects").observe((Object)this.pageModel));
        this.loadProjects(dbc);
        IViewerObservableValue viewerSingleSelection = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        ValueBindingBuilder.bind((IObservableValue)viewerSingleSelection).to(BeanProperties.value((String)"selectedProject").observe((Object)this.pageModel)).in(dbc);
        Button newButton = new Button((Composite)group, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)newButton);
        newButton.setText("New...");
        newButton.addSelectionListener(this.onNew());
        Button removeButton = new Button((Composite)group, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText("Remove...");
        removeButton.addSelectionListener(this.onRemove(dbc));
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to((IObservableValue)viewerSingleSelection).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Composite filler = new Composite((Composite)group, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)filler);
        Button refreshButton = new Button((Composite)group, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000008).applyTo((Control)refreshButton);
        refreshButton.setText("Refresh...");
        refreshButton.addSelectionListener(this.onRefresh(dbc));
    }

    private void loadProjects(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Loading OpenShift projects..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    ManageProjectsWizardPage.this.pageModel.loadProjects();
                    return Status.OK_STATUS;
                }
            }, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.logError(NLS.bind((String)"Could not load projects for connection {0}", (Object)this.pageModel.getConnection().toString()), (Throwable)e);
        }
    }

    private SelectionListener onNew() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardUtils.openWizardDialog((IWizard)new NewProjectWizard(ManageProjectsWizardPage.this.pageModel.getConnection(), ManageProjectsWizardPage.this.pageModel.getProjects()), (Shell)ManageProjectsWizardPage.this.getShell());
            }
        };
    }

    private SelectionListener onRemove(final DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = ManageProjectsWizardPage.this.pageModel.getSelectedProject();
                if (project == null) {
                    return;
                }
                boolean confirm = MessageDialog.openConfirm((Shell)ManageProjectsWizardPage.this.getShell(), (String)"OpenShift project deletion", (String)NLS.bind((String)"You are about to delete the \"{0}\" project.\nDo you want to continue?", (Object)project.getName()));
                if (!confirm) {
                    return;
                }
                final List<IProject> oldProjects = ManageProjectsWizardPage.this.pageModel.getProjects();
                final ArrayList<IProject> newProjects = new ArrayList<IProject>(oldProjects);
                newProjects.remove(project);
                DeleteResourceJob job = new DeleteResourceJob((IResource)project){

                    @Override
                    protected IStatus doRun(IProgressMonitor monitor) {
                        IStatus status = super.doRun(monitor);
                        if (status.isOK()) {
                            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)ManageProjectsWizardPage.this.pageModel.getConnection(), "openshift.projects", (Object)oldProjects, (Object)newProjects);
                        }
                        return status;
                    }
                };
                try {
                    WizardUtils.runInWizard((Job)job, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)ManageProjectsWizardPage.this.getContainer(), (DataBindingContext)dbc);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    OpenShiftUIActivator.getDefault().getLogger().logError(NLS.bind((String)"Could not delete OpenShift project {0}", (Object)project.getName()), (Throwable)ex);
                }
            }
        };
    }

    private SelectionListener onRefresh(final DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageProjectsWizardPage.this.refreshModel(dbc);
            }
        };
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerBuilder.ICellToolTipProvider<IProject> cellToolTipProvider = new TableViewerBuilder.ICellToolTipProvider<IProject>(){

            public String getToolTipText(IProject object) {
                return object.getDescription();
            }

            public int getToolTipDisplayDelayTime(IProject object) {
                return 0;
            }
        };
        this.viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IProject>(){

            public String getValue(IProject project) {
                return project.getName();
            }
        }).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Name").align(16384).weight(1).minWidth(75).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IProject>(){

            public String getValue(IProject project) {
                return project.getDisplayName();
            }
        }).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Display Name").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        return this.viewer;
    }

    private void refreshModel(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Refreshing Projects..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    ManageProjectsWizardPage.this.pageModel.refresh();
                    return Status.OK_STATUS;
                }
            }, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.logError(NLS.bind((String)"Could not refresh projects for connection {0}", (Object)this.pageModel.getConnection().toString()), (Throwable)e);
        }
    }

    public IProject getSelectedProject() {
        return this.pageModel.getSelectedProject();
    }

    public List<IProject> getProjects() {
        return this.pageModel.getProjects();
    }

    public void dispose() {
        this.pageModel.dispose();
        super.dispose();
    }
}

