/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.model.IProject;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizardPageModel;

public class ManageProjectsWizard
extends AbstractOpenShiftWizard<ManageProjectsWizardPageModel> {
    private String description;
    private ManageProjectsWizardPage manageProjectsWizardPage;

    public ManageProjectsWizard(Connection connection) {
        this(null, connection);
    }

    public ManageProjectsWizard(IProject project, Connection connection) {
        super("OpenShift Projects", (Object)new ManageProjectsWizardPageModel(project, connection));
        this.description = NLS.bind((String)"Manage projects for connection {0}", (Object)connection.toString(), (Object)connection);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.manageProjectsWizardPage = new ManageProjectsWizardPage(this.getWindowTitle(), this.description, (ManageProjectsWizardPageModel)((Object)this.getModel()), (IWizard)this);
        this.addPage((IWizardPage)this.manageProjectsWizardPage);
    }

    public IProject getSelectedProject() {
        if (this.manageProjectsWizardPage == null) {
            return null;
        }
        return this.manageProjectsWizardPage.getSelectedProject();
    }

    public List<IProject> getProjects() {
        return this.manageProjectsWizardPage.getProjects();
    }
}

