/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.template.IParameter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParameterColumnLabelProvider;

public class TemplateParametersPage
extends AbstractOpenShiftWizardPage {
    private ITemplateParametersPageModel model;
    private TableViewer viewer;

    public TemplateParametersPage(IWizard wizard, ITemplateParametersPageModel model) {
        super("Template Parameters", "Edit the parameter values to be substituted into the template.", "Template Parameter Page", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(container);
        Group templateParametersGroup = new Group(container, 0);
        templateParametersGroup.setText("Template Parameters");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)templateParametersGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)templateParametersGroup);
        Composite tableContainer = new Composite((Composite)templateParametersGroup, 0);
        this.viewer = TemplateParametersPage.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(BeanProperties.value((String)"selectedParameter").observe((Object)this.model)).in(dbc);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setInput((Object)BeanProperties.list((String)"parameters").observe((Object)this.model));
        Button editExistingButton = new Button((Composite)templateParametersGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit");
        editExistingButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedParameter").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button resetButton = new Button((Composite)templateParametersGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)resetButton);
        resetButton.setText("Reset");
        resetButton.addSelectionListener(this.onReset());
    }

    public static TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerBuilder.ICellToolTipProvider<IParameter> cellToolTipProvider = new TableViewerBuilder.ICellToolTipProvider<IParameter>(){

            public String getToolTipText(IParameter object) {
                return object.getDescription();
            }

            public int getToolTipDisplayDelayTime(IParameter object) {
                return 0;
            }
        };
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IParameter>(){

            public String getValue(IParameter variable) {
                return variable.getName();
            }
        }).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Name").align(16384).weight(2).minWidth(100).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TemplateParameterColumnLabelProvider()).cellToolTipProvider((TableViewerBuilder.ICellToolTipProvider)cellToolTipProvider).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IParameter first = (IParameter)e1;
                IParameter other = (IParameter)e2;
                return first.getName().compareTo(other.getName());
            }
        });
        return viewer;
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IParameter param = TemplateParametersPage.this.getSelectedParameter();
                InputDialog dialog = new InputDialog(TemplateParametersPage.this.getShell(), "Edit Template Parameter", NLS.bind((String)"Enter a value for {0}.\n{1}", (Object)param.getName(), (Object)param.getDescription()), param.getValue(), null);
                if (dialog.open() == 0) {
                    TemplateParametersPage.this.model.updateParameterValue(param, dialog.getValue());
                    TemplateParametersPage.this.viewer.refresh();
                }
            }
        };
    }

    private SelectionListener onReset() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.model.resetParameter(TemplateParametersPage.this.getSelectedParameter());
                TemplateParametersPage.this.viewer.refresh();
            }
        };
    }

    private IParameter getSelectedParameter() {
        return (IParameter)this.viewer.getStructuredSelection().getFirstElement();
    }
}

