/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.ITemplate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemStyledCellLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsContentProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateDetailViews;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizard;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class TemplateListPage
extends AbstractOpenShiftWizardPage {
    private ITemplateListPageModel model;
    private TreeViewer templatesViewer;

    public TemplateListPage(IWizard wizard, ITemplateListPageModel model) {
        super("Select template", "Templates choices may be reduced to a smaller list by typing the name of a tag in the text field.", "templateList", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 6).spacing(2, 2).applyTo(parent);
        this.createProjectControls(parent, dbc);
        SelectObservableValue uploadTemplate = new SelectObservableValue();
        ValueBindingBuilder.bind((IObservableValue)uploadTemplate).to(BeanProperties.value((String)"useUploadTemplate").observe((Object)this.model)).in(dbc);
        this.createUploadControls(parent, uploadTemplate, dbc);
        this.createServerTemplateControls(parent, uploadTemplate, dbc);
        this.model.setUseUploadTemplate(false);
    }

    private void createProjectControls(Composite parent, DataBindingContext dbc) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText("Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)projectLabel);
        ComboViewer projectsViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(projectsViewer.getControl());
        projectsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider());
        projectsViewer.setInput((Object)BeanProperties.list((String)"projectItems").observe((Object)this.model));
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)projectsViewer);
        Binding selectedProjectBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(IProject.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose a project.");
            }
        })).to(BeanProperties.value((String)"project").observe((Object)this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(TemplateTreeItems.INSTANCE))).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        BeanProperties.value((String)"connection").observe((Object)this.model).addValueChangeListener(this.onConnectionChanged());
        StyledText manageProjectsLink = new StyledText(parent, 64);
        StyledTextUtils.setTransparent((StyledText)manageProjectsLink);
        StyledTextUtils.setLinkText((String)"<a>Manage Projects</a>", (StyledText)manageProjectsLink);
        manageProjectsLink.setEditable(false);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).indent(8, 0).applyTo((Control)manageProjectsLink);
        manageProjectsLink.addListener(3, this.onManageProjectsClicked());
        Label filler = new Label(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)filler);
    }

    private Listener onManageProjectsClicked() {
        return new Listener(){

            public void handleEvent(Event event) {
                try {
                    WizardUtils.runInWizard((Job)new UIUpdatingJob("Opening projects wizard..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            return Status.OK_STATUS;
                        }

                        protected IStatus updateUI(IProgressMonitor monitor) {
                            IProject selectedProject;
                            ManageProjectsWizard manageProjectsWizard = new ManageProjectsWizard((Connection)TemplateListPage.this.model.getConnection());
                            TemplateListPage.this.loadResources(TemplateListPage.this.templatesViewer, TemplateListPage.this.model);
                            if (new OkCancelButtonWizardDialog(TemplateListPage.this.getShell(), (IWizard)manageProjectsWizard).open() == 0 && (selectedProject = manageProjectsWizard.getSelectedProject()) != null) {
                                TemplateListPage.this.model.setProject(selectedProject);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)TemplateListPage.this.getContainer());
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        };
    }

    private void createUploadControls(Composite parent, SelectObservableValue uploadTemplate, DataBindingContext dbc) {
        Button btnUploadTemplate = new Button(parent, 16);
        btnUploadTemplate.setText("Use a template from my local file system:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)btnUploadTemplate);
        uploadTemplate.addOption((Object)Boolean.TRUE, (IObservableValue)WidgetProperties.selection().observe((Widget)btnUploadTemplate));
        Text txtUploadedFileName = new Text(parent, 2048);
        txtUploadedFileName.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)txtUploadedFileName);
        ISWTObservableValue uploadedFilenameTextObservable = WidgetProperties.text((int)24).observe((Widget)txtUploadedFileName);
        ValueBindingBuilder.bind((IObservableValue)uploadedFilenameTextObservable).to(BeanProperties.value((String)"templateFileName").observe((Object)this.model)).in(dbc);
        Button btnBrowseFiles = new Button(parent, 0);
        btnBrowseFiles.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(120, -1).indent(6, 0).applyTo((Control)btnBrowseFiles);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnBrowseFiles)).notUpdatingParticipant()).to((IObservableValue)uploadTemplate).in(dbc);
        btnBrowseFiles.addSelectionListener((SelectionListener)this.onBrowseClicked());
    }

    private void createServerTemplateControls(Composite parent, SelectObservableValue uploadTemplate, DataBindingContext dbc) {
        Button btnServerTemplate = new Button(parent, 16);
        btnServerTemplate.setText("Use a template from the server:");
        GridDataFactory.fillDefaults().span(3, 1).indent(0, 8).align(4, 0x1000000).grab(true, false).applyTo((Control)btnServerTemplate);
        uploadTemplate.addOption((Object)Boolean.FALSE, (IObservableValue)WidgetProperties.selection().observe((Widget)btnServerTemplate));
        Composite treeComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().spacing(2, 2).applyTo(treeComposite);
        Text txtTemplateFilter = UIUtils.createSearchText((Composite)treeComposite);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).applyTo((Control)txtTemplateFilter);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)txtTemplateFilter)).notUpdatingParticipant()).to((IObservableValue)uploadTemplate).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        this.templatesViewer = this.createTemplatesViewer(treeComposite, txtTemplateFilter);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 180).applyTo(this.templatesViewer.getControl());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.templatesViewer.getControl())).notUpdatingParticipant()).to((IObservableValue)uploadTemplate).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        IViewerObservableValue selectedItem = ViewerProperties.singleSelection().observe((Viewer)this.templatesViewer);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedItem).converting((IConverter)new ObservableTreeItem2ModelConverter(ITemplate.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof ITemplate)) {
                    return ValidationStatus.cancel((String)"Please select a template to create your application.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"template").observe((Object)this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(TemplateTreeItems.INSTANCE))).in(dbc);
        txtTemplateFilter.addModifyListener(this.onFilterTextTyped(this.templatesViewer));
        WritableValue selectedResource = new WritableValue();
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedItem).converting((IConverter)new ObservableTreeItem2ModelConverter())).to((IObservableValue)selectedResource).notUpdatingParticipant()).in(dbc);
        Group detailsGroup = new Group(treeComposite, 0);
        detailsGroup.setText("Details");
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 106).applyTo((Control)detailsGroup);
        GridLayoutFactory.fillDefaults().margins(10, 6).spacing(2, 2).applyTo((Composite)detailsGroup);
        Composite detailsContainer = new Composite((Composite)detailsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 140).applyTo((Control)detailsContainer);
        new TemplateDetailViews((IObservableValue)selectedResource, null, detailsContainer, dbc).createControls();
        Button btnDetails = new Button((Composite)detailsGroup, 0);
        btnDetails.setText("Defined Resources...");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)btnDetails);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnDetails)).notUpdatingParticipant()).to((IObservableValue)selectedResource).converting((IConverter)new Converter(ITemplate.class, Boolean.class){

            public Object convert(Object value) {
                if (!(value instanceof ITemplate)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        })).in(dbc);
        btnDetails.addSelectionListener((SelectionListener)this.onDetailsClicked());
    }

    private TreeViewer createTemplatesViewer(Composite parent, Text templateFilterText) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"projectItems"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemStyledCellLabelProvider());
        viewer.setAutoExpandLevel(-1);
        viewer.setComparator(new ViewerComparator());
        viewer.addFilter((ViewerFilter)new TemplateViewerFilter(templateFilterText));
        viewer.setInput((Object)this.model);
        return viewer;
    }

    private SelectionAdapter onBrowseClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object file;
                FileDialog dialog = new FileDialog(TemplateListPage.this.getShell(), 4096);
                if (StringUtils.isNotBlank((String)TemplateListPage.this.model.getTemplateFileName())) {
                    file = new File(TemplateListPage.this.model.getTemplateFileName());
                    dialog.setFilterPath(((File)file).getParentFile().getAbsolutePath());
                }
                file = null;
                do {
                    IStatus status;
                    if ((file = dialog.open()) == null) continue;
                    try {
                        TemplateListPage.this.model.setTemplateFileName((String)file);
                        return;
                    }
                    catch (ClassCastException ex) {
                        status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
                        OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
                        ErrorDialog.openError((Shell)TemplateListPage.this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is not an OpenShift template.", (Object)file), (IStatus)status);
                    }
                    catch (UnsupportedVersionException ex) {
                        status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
                        OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
                        ErrorDialog.openError((Shell)TemplateListPage.this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is a template in a version that we do not support.", (Object)file), (IStatus)status);
                    }
                    catch (ResourceFactoryException ex) {
                        status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
                        OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
                        ErrorDialog.openError((Shell)TemplateListPage.this.getShell(), (String)"Template Error", (String)NLS.bind((String)"Unable to read and/or parse the file \"{0}\" as a template.", (Object)file), (IStatus)status);
                    }
                } while (file != null);
            }
        };
    }

    private SelectionAdapter onDetailsClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ResourceSummaryDialog(TemplateListPage.this.getShell(), TemplateListPage.this.model.getTemplate().getItems(), "Template Details", "The following resources will be created by using this template:", new ResourceDetailsLabelProvider(), new ResourceDetailsContentProvider()).open();
            }
        };
    }

    private ModifyListener onFilterTextTyped(final TreeViewer viewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewer.refresh();
                viewer.expandAll();
            }
        };
    }

    private IValueChangeListener onConnectionChanged() {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                TemplateListPage.this.loadResources(TemplateListPage.this.templatesViewer, TemplateListPage.this.model);
                TemplateListPage.this.templatesViewer.expandAll();
            }
        };
    }

    private void loadResources(final TreeViewer templatesViewer, final ITemplateListPageModel model) {
        if (!model.hasConnection()) {
            return;
        }
        try {
            Job jobs = new JobChainBuilder((Job)new AbstractDelegatingMonitorJob("Loading projects, templates..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    model.loadResources();
                    return Status.OK_STATUS;
                }
            }).runWhenSuccessfullyDone((Job)new UIJob("Verifying required project..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!model.hasProjects()) {
                        List<IProject> projects = new ObservableTreeItem2ModelConverter().convert(model.getProjectItems());
                        Connection connection = (Connection)model.getConnection();
                        NewProjectWizard newProjectWizard = new NewProjectWizard(connection, projects);
                        if (1 == WizardUtils.openWizardDialog((IWizard)newProjectWizard, (Shell)TemplateListPage.this.getShell())) {
                            WizardUtils.close((IWizard)TemplateListPage.this.getWizard());
                            return Status.CANCEL_STATUS;
                        }
                        model.loadResources();
                        model.setProject(newProjectWizard.getProject());
                    }
                    return Status.OK_STATUS;
                }
            }).runWhenSuccessfullyDone((Job)new UIJob("Expanding resource tree..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    templatesViewer.expandAll();
                    return Status.OK_STATUS;
                }
            }).build();
            WizardUtils.runInWizard((Job)jobs, (IWizardContainer)this.getContainer());
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.loadResources(this.templatesViewer, this.model);
        ((Composite)this.getControl()).layout(true, true);
    }

    private static class TemplateViewerFilter
    extends ViewerFilter {
        private Text filterText;

        public TemplateViewerFilter(Text filterText) {
            this.filterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof ObservableTreeItem) || !(((ObservableTreeItem)((Object)element)).getModel() instanceof ITemplate)) {
                return true;
            }
            ITemplate template = (ITemplate)((ObservableTreeItem)((Object)element)).getModel();
            return ResourceUtils.isMatching((String)this.filterText.getText(), (IResource)template);
        }
    }
}

