/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.template.ITemplate;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;

public class TemplateDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView templateView = new TemplateDetailView();

    public TemplateDetailViews(IObservableValue detailViewModel, IObservableValue disabled, Composite parent, DataBindingContext dbc) {
        super(detailViewModel, null, parent, dbc);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.templateView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.templateView};
    }

    private class TemplateDetailView
    extends AbstractStackedDetailViews.EmptyView {
        private Binding binding;
        private StyledText txtDescription;
        private CLabel classIcon;

        private TemplateDetailView() {
            super((AbstractStackedDetailViews)TemplateDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(8, 2).numColumns(4).spacing(6, 2).applyTo(container);
            this.classIcon = new CLabel(container, 0);
            GridDataFactory.fillDefaults().grab(false, true).span(1, 3).align(16384, 128).applyTo((Control)this.classIcon);
            this.txtDescription = new StyledText(container, 584);
            this.txtDescription.setAlwaysShowScrollBars(false);
            this.txtDescription.setWordWrap(true);
            StyledTextUtils.setTransparent((StyledText)this.txtDescription);
            GridDataFactory.fillDefaults().align(16384, 4).grab(true, true).span(3, 1).applyTo((Control)this.txtDescription);
            return container;
        }

        public void onVisible(IObservableValue templateObservable, DataBindingContext dbc) {
            Object value = templateObservable.getValue();
            this.txtDescription.setText("");
            if (!(value instanceof ITemplate) || DisposeUtils.isDisposed((Control)this.txtDescription)) {
                return;
            }
            ITemplate template = (ITemplate)value;
            if (template.isAnnotatedWith("provider")) {
                this.txtDescription.append(NLS.bind((String)"Provider: {0} \n", (Object)template.getAnnotation("provider")));
            }
            Map annotations = template.getAnnotations();
            this.addTextFor("description", annotations, this.txtDescription);
            this.updateImage((String)annotations.get("iconClass"));
        }

        private void updateImage(String iconClass) {
            Image image = iconClass == null ? null : OpenShiftImages.getAppImage(iconClass);
            this.classIcon.setImage(image);
        }

        private void addTextFor(String annotation, Map<String, String> annotations, StyledText text) {
            text.append((String)ObjectUtils.defaultIfNull((Object)annotations.get(annotation), (Object)""));
        }

        public void onInVisible(IObservableValue templateObservable, DataBindingContext dbc) {
            DataBindingUtils.dispose((ValidationStatusProvider)this.binding);
        }

        public boolean isViewFor(Object object) {
            return object instanceof ITemplate;
        }
    }
}

