/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueWizardModel;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizard;
import org.jboss.tools.openshift.internal.common.ui.wizard.KeyValueWizardModelBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.ui.validator.LabelKeyValidator;
import org.jboss.tools.openshift.internal.ui.validator.LabelValueValidator;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IResourceLabelsPageModel;

public class ResourceLabelsPage
extends AbstractOpenShiftWizardPage {
    private static final String LABEL = "Label";
    private static final String RESOURCE_LABEL = "Resource Label";
    private static final String PAGE_DESCRIPTION = "Add or edit the labels to be added to each resource. Labels are used to organize, group, or select objects and resources, such as pods and services.  Some labels cannot be modified and therefore cannot be edited or removed.";
    private IResourceLabelsPageModel model;
    private TableViewer viewer;

    protected ResourceLabelsPage(IWizard wizard, IResourceLabelsPageModel model) {
        super("Resource Labels", PAGE_DESCRIPTION, "Resource Labels Page", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(container);
        Group labelsGroup = new Group(container, 0);
        labelsGroup.setText("Labels");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)labelsGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)labelsGroup);
        Composite tableContainer = new Composite((Composite)labelsGroup, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(BeanProperties.value((String)"selectedLabel").observe((Object)this.model)).in(dbc);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setInput((Object)BeanProperties.list((String)"labels").observe((Object)this.model));
        Button addButton = new Button((Composite)labelsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)addButton);
        addButton.setText("Add");
        addButton.addSelectionListener(this.onAdd());
        Button editExistingButton = new Button((Composite)labelsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit");
        editExistingButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedLabel").observe((Object)this.model)).converting((IConverter)new IsNotNullOrReadOnlyBooleanConverter())).in(dbc);
        Button removeButton = new Button((Composite)labelsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText("Remove");
        removeButton.addSelectionListener(this.onRemove());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedLabel").observe((Object)this.model)).converting((IConverter)new IsNotNullOrReadOnlyBooleanConverter())).in(dbc);
    }

    private SelectionListener onRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResourceLabelsPageModel.Label label = (IResourceLabelsPageModel.Label)UIUtils.getFirstElement((ISelection)ResourceLabelsPage.this.viewer.getSelection(), IResourceLabelsPageModel.Label.class);
                if (MessageDialog.openQuestion((Shell)ResourceLabelsPage.this.getShell(), (String)"Remove Label", (String)NLS.bind((String)"Are you sure you want to delete the label {0} ", (Object)label.getName()))) {
                    ResourceLabelsPage.this.model.removeLabel(label);
                    ResourceLabelsPage.this.viewer.refresh();
                }
            }
        };
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResourceLabelsPageModel.Label label = (IResourceLabelsPageModel.Label)UIUtils.getFirstElement((ISelection)ResourceLabelsPage.this.viewer.getSelection(), IResourceLabelsPageModel.Label.class);
                IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder((IKeyValueItem)label).windowTitle(ResourceLabelsPage.RESOURCE_LABEL).title("Edit Label").description("Edit the resource label.").keyLabel(ResourceLabelsPage.LABEL).groupLabel(ResourceLabelsPage.LABEL).keyAfterConvertValidator((IValidator)new LabelKeyValidator(ResourceLabelsPage.this.model.getReadOnlyLabels())).valueAfterConvertValidator((IValidator)new LabelValueValidator()).build();
                OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(ResourceLabelsPage.this.getShell(), (IWizard)new KeyValueWizard((IKeyValueItem)label, dialogModel));
                if (dialog.open() == 0) {
                    ResourceLabelsPage.this.model.updateLabel(label, dialogModel.getKey(), dialogModel.getValue());
                }
            }
        };
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IKeyValueWizardModel dialogModel = new KeyValueWizardModelBuilder().windowTitle(ResourceLabelsPage.RESOURCE_LABEL).title("Add Label").description("Add a resource label.").keyLabel(ResourceLabelsPage.LABEL).groupLabel(ResourceLabelsPage.LABEL).keyAfterConvertValidator((IValidator)new LabelKeyValidator(ResourceLabelsPage.this.model.getReadOnlyLabels())).valueAfterConvertValidator((IValidator)new LabelValueValidator()).build();
                OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(ResourceLabelsPage.this.getShell(), (IWizard)new KeyValueWizard((IKeyValueItem)((IResourceLabelsPageModel.Label)UIUtils.getFirstElement((ISelection)ResourceLabelsPage.this.viewer.getSelection(), IResourceLabelsPageModel.Label.class)), dialogModel));
                if (dialog.open() == 0) {
                    ResourceLabelsPage.this.model.addLabel(dialogModel.getKey(), dialogModel.getValue());
                }
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceLabelsPageModel.Label>(){

            public String getValue(IResourceLabelsPageModel.Label label) {
                return label.getName();
            }
        }).name("Name").align(16384).weight(2).minWidth(100).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IResourceLabelsPageModel.Label>(){

            public String getValue(IResourceLabelsPageModel.Label label) {
                return label.getValue();
            }
        }).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IResourceLabelsPageModel.Label first = (IResourceLabelsPageModel.Label)e1;
                IResourceLabelsPageModel.Label other = (IResourceLabelsPageModel.Label)e2;
                return first.getName().compareTo(other.getName());
            }
        });
        return this.viewer;
    }

    private class IsNotNullOrReadOnlyBooleanConverter
    extends Converter {
        public IsNotNullOrReadOnlyBooleanConverter() {
            super(IResourceLabelsPageModel.Label.class, Boolean.class);
        }

        public Object convert(Object arg) {
            if (arg == null) {
                return Boolean.FALSE;
            }
            return !ResourceLabelsPage.this.model.getReadOnlyLabels().contains(((IResourceLabelsPageModel.Label)arg).getName());
        }
    }
}

