/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.internal.common.ui.viewer.GTK3WorkaroundStyledCellLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsContentProvider;

public class ResourceDetailsLabelProvider
extends GTK3WorkaroundStyledCellLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = this.getStyledText(element);
        if (text != null) {
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
        }
        super.update(cell);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            StyledString text = new StyledString(StringUtils.capitalize((String)resource.getKind().toString()));
            text.append(NLS.bind((String)" ({0})", (Object)resource.getName()), StyledString.QUALIFIER_STYLER);
            return text;
        }
        if (element instanceof ResourceDetailsContentProvider.ResourceProperty) {
            ResourceDetailsContentProvider.ResourceProperty property = (ResourceDetailsContentProvider.ResourceProperty)element;
            StyledString text = new StyledString(StringUtils.capitalize((String)property.getProperty()));
            text.append(": ");
            String value = null;
            if (property.getValue() instanceof Map) {
                value = org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)((Map)property.getValue()));
            } else if (property.getValue() instanceof Collection) {
                value = StringUtils.join((Collection)((Collection)property.getValue()), (String)", ");
            } else {
                String string = value = property.getValue() != null ? property.getValue().toString() : "";
            }
            if (StringUtils.isBlank((String)value)) {
                value = "(Not Provided)";
            }
            text.append(value, StyledString.QUALIFIER_STYLER);
            return text;
        }
        return null;
    }

    public Image getImage(Object paramObject) {
        return null;
    }
}

