/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.build.IBuildStrategy;
import com.openshift.restclient.model.build.IBuildTrigger;
import com.openshift.restclient.model.build.ICustomBuildStrategy;
import com.openshift.restclient.model.build.IDockerBuildStrategy;
import com.openshift.restclient.model.build.ISTIBuildStrategy;
import com.openshift.restclient.model.route.IRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceDetailsContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object node) {
        block19: {
            if (!(node instanceof IResource)) break block19;
            IResource resource = (IResource)node;
            ArrayList<ResourceProperty> properties = new ArrayList<ResourceProperty>();
            properties.add(new ResourceProperty("labels", resource.getLabels()));
            switch (resource.getKind()) {
                case "BuildConfig": {
                    this.getBuildConfigChildren(properties, (IBuildConfig)resource);
                    break;
                }
                case "DeploymentConfig": {
                    this.getDeploymentConfigChildren(properties, (IDeploymentConfig)resource);
                    break;
                }
                case "Service": {
                    this.getServiceChildren(properties, (IService)resource);
                    break;
                }
                case "Route": {
                    this.getRouteChildren(properties, (IRoute)resource);
                    break;
                }
                case "ImageStream": {
                    this.getImageStreamChildren(properties, (IImageStream)resource);
                }
            }
            return properties.toArray();
        }
        return new Object[0];
    }

    private void getRouteChildren(Collection<ResourceProperty> properties, IRoute resource) {
        properties.add(new ResourceProperty("host", resource.getHost()));
        properties.add(new ResourceProperty("path", resource.getPath()));
        properties.add(new ResourceProperty("service", resource.getServiceName()));
    }

    private void getImageStreamChildren(Collection<ResourceProperty> properties, IImageStream resource) {
        properties.add(new ResourceProperty("registry", resource.getDockerImageRepository()));
    }

    private void getServiceChildren(Collection<ResourceProperty> properties, IService resource) {
        properties.add(new ResourceProperty("selector", resource.getSelector()));
        properties.add(new ResourceProperty("port", resource.getPort()));
    }

    private void getDeploymentConfigChildren(Collection<ResourceProperty> properties, IDeploymentConfig resource) {
        properties.add(new ResourceProperty("triggers", resource.getTriggerTypes()));
        properties.add(new ResourceProperty("strategy", resource.getDeploymentStrategyType()));
        properties.add(new ResourceProperty("template selector", resource.getReplicaSelector()));
    }

    private void getBuildConfigChildren(Collection<ResourceProperty> properties, IBuildConfig config) {
        IBuildStrategy buildStrategy = config.getBuildStrategy();
        properties.add(new ResourceProperty("strategy", buildStrategy.getType().toString()));
        switch (buildStrategy.getType()) {
            case "Source": 
            case "STI": {
                ISTIBuildStrategy sti = (ISTIBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("builder image", sti.getImage().toString()));
                break;
            }
            case "Docker": {
                IDockerBuildStrategy docker = (IDockerBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("base image", docker.getBaseImage().toString()));
                break;
            }
            case "Custom": {
                ICustomBuildStrategy custom = (ICustomBuildStrategy)buildStrategy;
                properties.add(new ResourceProperty("builder image", custom.getImage().toString()));
            }
        }
        properties.add(new ResourceProperty("source URL", config.getSourceURI()));
        properties.add(new ResourceProperty("output to", config.getOutputRepositoryName()));
        ArrayList<String> triggers = new ArrayList<String>();
        for (IBuildTrigger trigger : config.getBuildTriggers()) {
            triggers.add(trigger.getType().toString());
        }
        properties.add(new ResourceProperty("build triggers", triggers));
    }

    public Object[] getElements(Object rootElements) {
        if (!(rootElements instanceof Collection)) {
            return new Object[0];
        }
        ArrayList resources = new ArrayList((Collection)rootElements);
        Collections.sort(resources, new Comparator<IResource>(){

            @Override
            public int compare(IResource first, IResource second) {
                int result = first.getKind().toString().compareTo(second.getKind().toString());
                if (result != 0) {
                    return result;
                }
                return first.getName().compareTo(second.getName());
            }
        });
        return resources.toArray();
    }

    public boolean hasChildren(Object node) {
        return node instanceof IResource;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldValue, Object newValue) {
    }

    public Object getParent(Object paramObject) {
        return null;
    }

    public static class ResourceProperty {
        private Object value;
        private String property;

        ResourceProperty(String property, Object value) {
            this.property = property;
            this.value = value;
        }

        String getProperty() {
            return this.property;
        }

        Object getValue() {
            return this.value;
        }
    }
}

