/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IResourceDetailsModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateTreeItems;

public class NewApplicationWizardModel
extends ObservablePojo
implements IResourceDetailsModel,
ITemplateListPageModel,
ITemplateParametersPageModel,
IResourceLabelsPageModel,
IConnectionAware<Connection> {
    private Connection connection;
    private IProject project;
    private List<ObservableTreeItem> projectItems = new ArrayList<ObservableTreeItem>();
    private ITemplate template;
    private ITemplate uploadedTemplate;
    private List<IParameter> parameters = new ArrayList<IParameter>();
    private IParameter selectedParameter;
    private HashMap<String, String> originalValueMap;
    private Collection<String> readonlyLabels = Arrays.asList("template");
    private List<IResourceLabelsPageModel.Label> labels;
    private IResourceLabelsPageModel.Label selectedLabel;
    private Collection<IResource> items = new ArrayList<IResource>();
    private boolean uploadTemplate = true;
    private String templateFilename;
    private IResourceFactory resourceFactory;

    private void update(boolean useUploadTemplate, IProject selectedProject, List<ObservableTreeItem> projectItems, ITemplate selectedTemplate) {
        this.uploadTemplate = useUploadTemplate;
        this.firePropertyChange("useUploadTemplate", this.uploadTemplate, this.uploadTemplate);
        this.updateProjectItems(projectItems);
        this.project = this.getProjectOrDefault(selectedProject, projectItems);
        this.firePropertyChange("project", this.project, this.project);
        this.template = selectedTemplate;
        this.firePropertyChange("template", this.template, this.template);
        this.initTemplateParameters(selectedTemplate);
    }

    private void updateProjectItems(List<ObservableTreeItem> projectItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.projectItems);
        ArrayList<ObservableTreeItem> newItems = new ArrayList<ObservableTreeItem>();
        if (projectItems != null) {
            newItems.addAll(projectItems);
        }
        this.projectItems.clear();
        this.projectItems.addAll(newItems);
        this.firePropertyChange("projectItems", oldItems, this.projectItems);
    }

    @Override
    public Collection<IResource> getItems() {
        return this.items;
    }

    private void setItems(Collection<IResource> items) {
        this.items = items;
        this.firePropertyChange("items", this.items, this.items);
    }

    @Override
    public void setTemplate(ITemplate template) {
        this.update(this.uploadTemplate, this.project, this.projectItems, template);
    }

    private void initTemplateParameters(ITemplate template) {
        if (template == null) {
            return;
        }
        this.setParameters(new ArrayList<IParameter>(template.getParameters().values()));
        this.setItems(template.getItems());
        this.setLabels(template.getObjectLabels());
    }

    private IProject getProjectOrDefault(IProject project, List<ObservableTreeItem> projects) {
        if (project == null) {
            project = this.getDefaultProject(projects);
        }
        return project;
    }

    @Override
    public void setProject(IProject project) {
        this.update(this.uploadTemplate, project, this.projectItems, this.template);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public ITemplate getTemplate() {
        return this.template;
    }

    @Override
    public void loadResources() {
        if (this.connection == null) {
            return;
        }
        ObservableTreeItem connectionItem = TemplateTreeItems.INSTANCE.create(this.connection);
        connectionItem.load();
        List<ObservableTreeItem> projects = connectionItem.getChildren();
        this.setProjectItems(projects);
    }

    @Override
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<IParameter> parameters) {
        this.parameters = parameters;
        this.firePropertyChange("parameters", this.parameters, this.parameters);
        this.originalValueMap = new HashMap(parameters.size());
        for (IParameter param : parameters) {
            this.originalValueMap.put(param.getName(), param.getValue());
        }
    }

    @Override
    public IParameter getSelectedParameter() {
        return this.selectedParameter;
    }

    @Override
    public void setSelectedParameter(IParameter parameter) {
        this.selectedParameter = parameter;
        this.firePropertyChange("selectedParameter", this.selectedParameter, this.selectedParameter);
    }

    @Override
    public void updateParameterValue(IParameter param, String value) {
        param.setValue(value);
    }

    @Override
    public void resetParameter(IParameter param) {
        this.updateParameterValue(param, this.originalValueMap.get(param.getName()));
    }

    @Override
    public List<IResourceLabelsPageModel.Label> getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(List<IResourceLabelsPageModel.Label> labels) {
        this.labels = labels;
        this.firePropertyChange("labels", this.labels, this.labels);
    }

    @Override
    public Collection<String> getReadOnlyLabels() {
        return this.readonlyLabels;
    }

    @Override
    public void setSelectedLabel(IResourceLabelsPageModel.Label label) {
        this.selectedLabel = label;
        this.firePropertyChange("selectedLabel", this.selectedLabel, this.selectedLabel);
    }

    @Override
    public IResourceLabelsPageModel.Label getSelectedLabel() {
        return this.selectedLabel;
    }

    private void setLabels(Map<String, String> labelMap) {
        if (labelMap == null) {
            return;
        }
        ArrayList<IResourceLabelsPageModel.Label> labels = new ArrayList<IResourceLabelsPageModel.Label>(labelMap.size());
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            labels.add(new IResourceLabelsPageModel.Label(entry.getKey(), entry.getValue()));
        }
        this.setLabels(labels);
    }

    @Override
    public void removeLabel(IResourceLabelsPageModel.Label label) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        int index = this.labels.indexOf(label);
        this.labels.remove(label);
        this.fireIndexedPropertyChange("labels", index, old, Collections.unmodifiableList(this.labels));
    }

    @Override
    public void updateLabel(IResourceLabelsPageModel.Label label, String key, String value) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        int index = this.labels.indexOf(label);
        this.labels.set(index, new IResourceLabelsPageModel.Label(key, value));
        this.fireIndexedPropertyChange("labels", index, old, Collections.unmodifiableList(this.labels));
    }

    @Override
    public void addLabel(String key, String value) {
        ArrayList<IResourceLabelsPageModel.Label> old = new ArrayList<IResourceLabelsPageModel.Label>(this.labels);
        this.labels.add(new IResourceLabelsPageModel.Label(key, value));
        this.fireIndexedPropertyChange("labels", this.labels.size(), old, Collections.unmodifiableList(this.labels));
    }

    @Override
    public void setUseUploadTemplate(boolean uploadTemplate) {
        this.update(uploadTemplate, this.project, this.projectItems, this.template);
    }

    @Override
    public boolean isUseUploadTemplate() {
        return this.uploadTemplate;
    }

    @Override
    public void setTemplateFileName(String name) {
        try {
            try {
                this.uploadedTemplate = (ITemplate)this.resourceFactory.create(this.createInputStream(name));
                this.setTemplate(this.uploadedTemplate);
            }
            catch (FileNotFoundException e) {
                name = "";
                this.setTemplate(null);
                throw new OpenShiftException((Throwable)e, "Unable to find the file to upload", new Object[0]);
            }
            catch (ResourceFactoryException | ClassCastException e) {
                name = "";
                this.setTemplate(null);
                throw e;
            }
        }
        finally {
            this.templateFilename = name;
            this.firePropertyChange("templateFileName", this.templateFilename, this.templateFilename);
        }
    }

    public InputStream createInputStream(String fileName) throws FileNotFoundException {
        return new FileInputStream(fileName);
    }

    @Override
    public String getTemplateFileName() {
        return this.templateFilename;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public Connection setConnection(Connection connection) {
        if (ObjectUtils.equals((Object)connection, (Object)this.connection)) {
            return this.connection;
        }
        this.setResourceFactory(connection);
        this.reset();
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
        return connection;
    }

    private void reset() {
        this.update(this.uploadTemplate, null, null, null);
    }

    private IProject getDefaultProject(List<ObservableTreeItem> projects) {
        if (projects == null || projects.size() == 0) {
            return null;
        }
        return (IProject)projects.get(0).getModel();
    }

    private void setResourceFactory(Connection connection) {
        if (connection != null) {
            this.resourceFactory = connection.getResourceFactory();
        }
    }

    public void setResourceFactory(IResourceFactory factory) {
        this.resourceFactory = factory;
    }

    private void setProjectItems(List<ObservableTreeItem> projects) {
        this.update(this.uploadTemplate, null, projects, this.template);
    }

    @Override
    public List<ObservableTreeItem> getProjectItems() {
        return this.projectItems;
    }

    @Override
    public boolean hasProjects() {
        return this.projectItems != null && this.projectItems.size() > 0;
    }

    public Object getContext() {
        return null;
    }
}

