/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryContentProvider;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryLabelProvider;
import org.jboss.tools.openshift.internal.ui.job.CreateApplicationFromTemplateJob;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParametersPage;

public class NewApplicationSummaryDialog
extends ResourceSummaryDialog {
    private CreateApplicationFromTemplateJob job;

    public NewApplicationSummaryDialog(Shell parentShell, CreateApplicationFromTemplateJob job, String message) {
        super(parentShell, job.getResources(), "Create Application Summary", message, new ResourceSummaryLabelProvider(), new ResourceSummaryContentProvider());
        this.job = job;
    }

    @Override
    protected void createAreaAfterResourceSummary(Composite parent) {
        if (this.job.getParameters().size() == 0) {
            return;
        }
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)area);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(area);
        Label lblParams = new Label(area, 0);
        lblParams.setText("Please make note of the following parameters which may \ninclude values required to administer your resources:");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)lblParams);
        Composite parameters = new Composite(area, 0);
        GridDataFactory.fillDefaults().hint(100, 250).grab(true, true).applyTo((Control)parameters);
        TableViewer viewer = TemplateParametersPage.createTable(parameters);
        viewer.setInput(this.job.getParameters());
    }
}

