/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp.operation;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.GeneralProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.MavenProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.WontOverwriteException;

public class ImportNewProject {
    private File cloneDestination;
    private String gitUrl;

    public ImportNewProject(String gitUrl, File cloneDestination) {
        this.gitUrl = gitUrl;
        this.cloneDestination = cloneDestination;
    }

    public void execute(IProgressMonitor monitor) throws OpenShiftException, CoreException, InterruptedException, URISyntaxException, InvocationTargetException, IOException, NoWorkTreeException, GitAPIException {
        if (this.cloneDestinationExists()) {
            throw new WontOverwriteException(NLS.bind((String)"There's already a folder at {0}. The new OpenShift project would overwrite it. Please choose another destination to clone to.", (Object)this.getCloneDestination().getAbsolutePath()), new Object[0]);
        }
        File repositoryFolder = this.cloneRepository(this.gitUrl, this.cloneDestination, monitor);
        List<IProject> importedProjects = this.importProjectsFrom(repositoryFolder, monitor);
        this.connectToGitRepo(importedProjects, repositoryFolder, monitor);
    }

    private List<IProject> importProjectsFrom(File folder, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenProjectImportOperation mavenImport = new MavenProjectImportOperation(folder);
        List importedProjects = Collections.emptyList();
        importedProjects = mavenImport.isMavenProject() ? mavenImport.importToWorkspace(monitor) : new GeneralProjectImportOperation(folder).importToWorkspace(monitor);
        return importedProjects;
    }

    private void connectToGitRepo(List<IProject> projects, File projectFolder, IProgressMonitor monitor) throws CoreException {
        for (IProject project : projects) {
            if (project == null) continue;
            EGitUtils.connect((IProject)project, (IProgressMonitor)monitor);
        }
    }

    protected File cloneRepository(String gitUrl, File destination, IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        monitor.subTask(NLS.bind((String)"Cloning  {0}...", (Object)gitUrl));
        EGitUIUtils.ensureEgitUIIsStarted();
        EGitUtils.cloneRepository((String)gitUrl, (String)"origin", (File)destination, (CloneOperation.PostCloneTask)EGitUIUtils.ADD_TO_REPOVIEW_TASK, (IProgressMonitor)monitor);
        return destination;
    }

    protected File getCloneDestination() {
        return this.cloneDestination;
    }

    protected boolean cloneDestinationExists() {
        return this.cloneDestination != null && this.cloneDestination.exists();
    }
}

