/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IBuildConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.IGitCloningPageModel;

public class ImportApplicationWizardModel
extends ObservableUIPojo
implements IBuildConfigPageModel,
IGitCloningPageModel {
    private static final Pattern PROJECT_NAME_PATTERN = Pattern.compile("([^\\/\\.git]+)(\\.git)?$");
    private Connection connection;
    private Object selectedItem;
    private String repoPath = this.getDefaultRepoPath();
    private boolean useDefaultRepoPath = true;
    private String projectName;
    private ObservableTreeItem buildConfigsTreeRoot;

    ImportApplicationWizardModel() {
    }

    private String getDefaultRepoPath() {
        return EGitUIUtils.getEGitDefaultRepositoryPath();
    }

    @Override
    public IBuildConfig getSelectedBuildConfig() {
        return this.getBuildConfig(this.selectedItem);
    }

    private IBuildConfig getBuildConfig(Object item) {
        if (!(item instanceof IBuildConfig)) {
            return null;
        }
        return (IBuildConfig)item;
    }

    public String getGitUrl() {
        IBuildConfig config = this.getSelectedBuildConfig();
        if (config == null) {
            return null;
        }
        return config.getSourceURI();
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.selectedItem = selectedItem;
        this.firePropertyChange("selectedItem", this.selectedItem, this.selectedItem);
        this.setProjectName(this.getBuildConfig(selectedItem));
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setRepositoryPath(String path) {
        this.repoPath = path;
        this.firePropertyChange("repositoryPath", this.repoPath, this.repoPath);
    }

    @Override
    public String getRepositoryPath() {
        return this.repoPath;
    }

    public File getCloneDestination() {
        if (StringUtils.isEmpty((String)this.repoPath) || StringUtils.isEmpty((String)this.projectName)) {
            return null;
        }
        return new Path(this.repoPath).append(this.projectName).toFile();
    }

    @Override
    public void setUseDefaultRepositoryPath(boolean useDefault) {
        this.useDefaultRepoPath = useDefault;
        this.firePropertyChange("useDefaultRepositoryPath", this.useDefaultRepoPath, this.useDefaultRepoPath);
        if (this.useDefaultRepoPath) {
            this.setRepositoryPath(this.getDefaultRepoPath());
        }
    }

    @Override
    public boolean isUseDefaultRepositoryPath() {
        return this.useDefaultRepoPath;
    }

    private void setProjectName(IBuildConfig config) {
        this.setProjectName(this.getProjectName(config));
    }

    private String getProjectName(IBuildConfig config) {
        Matcher matcher;
        String projectName = null;
        if (config != null && (matcher = PROJECT_NAME_PATTERN.matcher(config.getSourceURI())).find() && matcher.group(1) != null) {
            projectName = matcher.group(1);
        }
        return projectName;
    }

    @Override
    public void setProjectName(String name) {
        this.projectName = name;
        this.firePropertyChange("projectName", this.projectName, this.projectName);
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public Connection setConnection(Connection connection) {
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
        this.setBuildConfigsTreeRoot(connection);
        return this.connection;
    }

    private void setBuildConfigsTreeRoot(Connection connection) {
        BuildConfigTreeItems.ConnectionTreeItem buildConfigTreeRoot = new BuildConfigTreeItems.ConnectionTreeItem(connection);
        this.setBuildConfigsTreeRoot(buildConfigTreeRoot);
    }

    @Override
    public void setBuildConfigsTreeRoot(ObservableTreeItem root) {
        this.buildConfigsTreeRoot = root;
        this.firePropertyChange("buildConfigsTreeRoot", (Object)this.buildConfigsTreeRoot, (Object)this.buildConfigsTreeRoot);
    }

    @Override
    public void loadBuildConfigs() {
        if (this.buildConfigsTreeRoot == null) {
            if (this.connection == null) {
                return;
            }
            this.setBuildConfigsTreeRoot(this.connection);
        }
        this.buildConfigsTreeRoot.load();
    }

    @Override
    public ObservableTreeItem getBuildConfigsTreeRoot() {
        return this.buildConfigsTreeRoot;
    }

    public Object getContext() {
        return null;
    }
}

