/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.ui.validator.LabelValueValidator;

public class ProjectNameValidator
extends LabelValueValidator {
    private String message;

    public ProjectNameValidator(String defaultMessage) {
        super("project name");
        this.message = defaultMessage;
    }

    @Override
    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return this.getFailedStatus();
        }
        String param = (String)value;
        if (StringUtils.isEmpty((String)param)) {
            return ValidationStatus.cancel((String)this.message);
        }
        if ("..".equals(param) || ".".equals(param)) {
            return ValidationStatus.error((String)"Project name cannot be '.' or '..'");
        }
        if (param.length() < 2) {
            return ValidationStatus.error((String)NLS.bind((String)"Project name length must be between {0} and {1} characters.", (Object)2, (Object)63));
        }
        return super.validate(value);
    }
}

