/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class LabelValueValidator
implements IValidator {
    public static final int LABEL_MAXLENGTH = 63;
    private static final Pattern LABEL_REGEXP = Pattern.compile("^(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])?$");
    private final String failureMessage = "A valid {0} is alphanumeric (a-z, and 0-9), with the characters '-', '.' allowed anywhere except first or last.";
    private final IStatus FAILED;

    public LabelValueValidator() {
        this("label value");
    }

    public LabelValueValidator(String element) {
        this.FAILED = ValidationStatus.error((String)NLS.bind((String)"A valid {0} is alphanumeric (a-z, and 0-9), with the characters '-', '.' allowed anywhere except first or last.", (Object)element));
    }

    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)"Value is not an instance of a string");
        }
        String value = (String)paramObject;
        if (StringUtils.isEmpty((String)value)) {
            return this.FAILED;
        }
        if (value.length() > 63) {
            return ValidationStatus.error((String)NLS.bind((String)"Maximum length allowed is {0} characters", (Object)63));
        }
        if (!LABEL_REGEXP.matcher(value).matches()) {
            return this.FAILED;
        }
        return ValidationStatus.OK_STATUS;
    }

    protected boolean validateLabel(String value) {
        if (value.length() > 63) {
            return false;
        }
        return LABEL_REGEXP.matcher(value).matches();
    }

    protected IStatus getFailedStatus() {
        return this.FAILED;
    }
}

