/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.internal.ui.validator.LabelValueValidator;

public class LabelKeyValidator
extends LabelValueValidator {
    public static final int SUBDOMAIN_MAXLENGTH = 253;
    private static final Pattern SUBDOMAIN_REGEXP = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$");
    private Collection<String> readonlykeys;
    private static final String failureMessage = "A valid object label has the form [domain/]name where a name is an alphanumeric (a-z, and 0-9) string, with a maximum length of 63 characters, with the '-' character allowed anywhere except the first or last character. A domain is a sequence of names separated by the '.' character with a maximum length of 253 characters.";
    private final IStatus FAILED = ValidationStatus.error((String)"A valid object label has the form [domain/]name where a name is an alphanumeric (a-z, and 0-9) string, with a maximum length of 63 characters, with the '-' character allowed anywhere except the first or last character. A domain is a sequence of names separated by the '.' character with a maximum length of 253 characters.");

    public LabelKeyValidator(Collection<String> readonlykeys) {
        this.readonlykeys = readonlykeys != null ? readonlykeys : new ArrayList(0);
    }

    @Override
    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return this.FAILED;
        }
        String value = (String)paramObject;
        if (StringUtils.isEmpty((String)value)) {
            return this.FAILED;
        }
        if (this.readonlykeys.contains(value)) {
            return ValidationStatus.error((String)"Adding a label with a key that is the same as a readonly label is not allowed");
        }
        String[] parts = value.split("/");
        switch (parts.length) {
            case 1: {
                return super.validate(value);
            }
            case 2: {
                return this.validateSubdomain(parts[0]) && this.validateLabel(parts[1]) ? ValidationStatus.OK_STATUS : this.FAILED;
            }
        }
        return this.FAILED;
    }

    private boolean validateSubdomain(String value) {
        if (value.length() > 253) {
            return false;
        }
        return SUBDOMAIN_REGEXP.matcher(value).matches();
    }
}

