/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.route.IRoute;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;

public class RoutePropertySource
extends ResourcePropertySource<IRoute> {
    private static final String SERVICE = "service";
    private static final String HOST_PATH = "host/path";

    public RoutePropertySource(IRoute resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getResourcePropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)HOST_PATH, "URI"), new TextPropertyDescriptor((Object)SERVICE, "Service")};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (HOST_PATH.equals(id)) {
            return NLS.bind((String)"{0}{1}", (Object)((IRoute)this.getResource()).getHost(), (Object)((IRoute)this.getResource()).getPath());
        }
        if (SERVICE.equals(id)) {
            return ((IRoute)this.getResource()).getServiceName();
        }
        return super.getPropertyValue(id);
    }
}

