/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.property;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.build.ICustomBuildStrategy;
import com.openshift.restclient.model.build.IDockerBuildStrategy;
import com.openshift.restclient.model.build.IGitBuildSource;
import com.openshift.restclient.model.build.ISTIBuildStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.ExtTextPropertyDescriptor;
import org.jboss.tools.openshift.internal.ui.property.KeyValuePropertySource;
import org.jboss.tools.openshift.internal.ui.property.ResourcePropertySource;
import org.jboss.tools.openshift.internal.ui.property.build.ImageChangePropertySource;
import org.jboss.tools.openshift.internal.ui.property.build.WebHooksPropertySource;

public class BuildConfigPropertySource
extends ResourcePropertySource<IBuildConfig> {
    private static final String TRIGGERS = "Triggers";
    private static final String IMAGE = "Image";
    private static final String ENVIRONMENT_VARIABLES = "Environment Variables";
    private static final String STRATEGY = "Strategy";
    private static final String SOURCE = "Source";

    public BuildConfigPropertySource(IBuildConfig resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getResourcePropertyDescriptors() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(this.getBuildTriggerPropertyDescriptors());
        switch (((IBuildConfig)this.getResource()).getBuildStrategy().getType()) {
            case "Custom": {
                all.addAll(this.getCustomPropertyDescriptors());
                break;
            }
            case "Docker": {
                all.addAll(this.getDockerPropertyDescriptors());
                break;
            }
            case "Source": 
            case "STI": {
                all.addAll(this.getSTIPropertyDescriptors());
            }
        }
        switch (((IBuildConfig)this.getResource()).getBuildSource().getType()) {
            case "Git": {
                all.addAll(this.getGitBuildSource());
            }
        }
        all.add((Object)new ExtTextPropertyDescriptor((Object)Ids.OUTPUT_REPO_NAME, "Image Stream Name", "Output"));
        return all.toArray(new IPropertyDescriptor[0]);
    }

    private List<IPropertyDescriptor> getBuildTriggerPropertyDescriptors() {
        return Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.TRIGGERS_WEB, "Webhooks", TRIGGERS), new ExtTextPropertyDescriptor((Object)Ids.TRIGGERS_IMAGE_CHANGE, "Image Change", TRIGGERS)});
    }

    private List<IPropertyDescriptor> getGitBuildSource() {
        return Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.SOURCE_TYPE, "Type", SOURCE), new ExtTextPropertyDescriptor((Object)Ids.SOURCE_GIT_REF, "Ref", SOURCE), new ExtTextPropertyDescriptor((Object)Ids.SOURCE_URI, "URI", SOURCE)});
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id instanceof Ids) {
            switch ((Ids)((Object)id)) {
                case Type: {
                    return ((IBuildConfig)this.getResource()).getBuildStrategy().getType();
                }
                case CUSTOM_EXPOSE_DOCKER_SOCKET: {
                    return ((ICustomBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).exposeDockerSocket();
                }
                case CUSTOM_ENV: {
                    return new KeyValuePropertySource(((ICustomBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getEnvironmentVariables());
                }
                case CUSTOM_IMAGE: {
                    return ((ICustomBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getImage();
                }
                case DOCKER_CONTEXT_DIR: {
                    return ((IDockerBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getContextDir();
                }
                case DOCKER_IMAGE: {
                    return ((IDockerBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getBaseImage();
                }
                case OUTPUT_REPO_NAME: {
                    return ((IBuildConfig)this.getResource()).getOutputRepositoryName();
                }
                case SOURCE_TYPE: {
                    return ((IBuildConfig)this.getResource()).getBuildSource().getType();
                }
                case SOURCE_URI: {
                    return ((IBuildConfig)this.getResource()).getSourceURI();
                }
                case SOURCE_GIT_REF: {
                    String ref = ((IGitBuildSource)((IBuildConfig)this.getResource()).getBuildSource()).getRef();
                    return "".equals(ref) ? "master" : ref;
                }
                case STI_SCRIPT_LOCATION: {
                    return ((ISTIBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getScriptsLocation();
                }
                case STI_IMAGE: {
                    return ((ISTIBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getImage();
                }
                case STI_ENV: {
                    return new KeyValuePropertySource(((ISTIBuildStrategy)((IBuildConfig)this.getResource()).getBuildStrategy()).getEnvironmentVariables());
                }
                case TRIGGERS_IMAGE_CHANGE: {
                    return new ImageChangePropertySource(((IBuildConfig)this.getResource()).getBuildTriggers());
                }
                case TRIGGERS_WEB: {
                    return new WebHooksPropertySource(((IBuildConfig)this.getResource()).getBuildTriggers());
                }
            }
        }
        return super.getPropertyValue(id);
    }

    private List<IPropertyDescriptor> getDockerPropertyDescriptors() {
        return Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.Type, "Type", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.DOCKER_CONTEXT_DIR, "Context Dir", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.DOCKER_IMAGE, IMAGE, STRATEGY)});
    }

    private List<IPropertyDescriptor> getCustomPropertyDescriptors() {
        return Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.Type, "Type", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.CUSTOM_EXPOSE_DOCKER_SOCKET, "Expose Docker Socket", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.CUSTOM_IMAGE, IMAGE, STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.CUSTOM_ENV, ENVIRONMENT_VARIABLES, STRATEGY)});
    }

    private List<IPropertyDescriptor> getSTIPropertyDescriptors() {
        return Arrays.asList(new IPropertyDescriptor[]{new ExtTextPropertyDescriptor((Object)Ids.Type, "Type", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.STI_SCRIPT_LOCATION, "Script Location", STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.STI_IMAGE, IMAGE, STRATEGY), new ExtTextPropertyDescriptor((Object)Ids.STI_ENV, ENVIRONMENT_VARIABLES, STRATEGY)});
    }

    public static enum Ids {
        Type,
        CUSTOM_EXPOSE_DOCKER_SOCKET,
        CUSTOM_IMAGE,
        CUSTOM_ENV,
        DOCKER_CONTEXT_DIR,
        DOCKER_IMAGE,
        OUTPUT_REPO_NAME,
        STI_SCRIPT_LOCATION,
        STI_IMAGE,
        STI_ENV,
        SOURCE_TYPE,
        SOURCE_GIT_REF,
        SOURCE_URI,
        TRIGGERS_WEB,
        TRIGGERS_IMAGE_CHANGE;

    }
}

