/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class OpenShiftPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int WHICH_CMD_TIMEOUT = 10000;
    private static final int WHICH_CMD_SUCCESS = 0;
    private static final String OC_BINARY_NAME;
    private static final String[] EXTENSIONS;
    private FileFieldEditor cliLocationEditor;

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            EXTENSIONS = new String[]{"exe"};
            OC_BINARY_NAME = "oc.exe";
        } else {
            EXTENSIONS = new String[0];
            OC_BINARY_NAME = "oc";
        }
    }

    public OpenShiftPreferencePage() {
        super(1);
    }

    public void createFieldEditors() {
        this.cliLocationEditor = new FileFieldEditor("openshift.cli.location", NLS.bind((String)"{0} location", (Object)OC_BINARY_NAME), this.getFieldEditorParent());
        this.cliLocationEditor.setFilterPath(SystemUtils.getUserHome());
        this.cliLocationEditor.setFileExtensions(EXTENSIONS);
        this.addField((FieldEditor)this.cliLocationEditor);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(OpenShiftUIActivator.getDefault().getCorePreferenceStore());
    }

    protected void performDefaults() {
        String location = this.findOCLocation();
        if (StringUtils.isBlank((String)location)) {
            String message = NLS.bind((String)"Could not find the openshift binary \"{0}\" on your path.", (Object)OC_BINARY_NAME);
            OpenShiftUIActivator.getDefault().getLogger().logWarning(message);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"No OpenShift binary", (String)message);
            return;
        }
        this.cliLocationEditor.setStringValue(location);
    }

    public boolean performOk() {
        boolean valid = super.performOk() && this.validateLocation();
        this.setValid(valid);
        return valid;
    }

    private boolean validateLocation() {
        String location = this.cliLocationEditor.getStringValue();
        if (StringUtils.isBlank((String)location)) {
            return true;
        }
        File file = new File(location);
        if (!OC_BINARY_NAME.equals(file.getName())) {
            this.setErrorMessage(NLS.bind((String)"{0} is not the openshift 'oc' executable.", (Object)file));
            return false;
        }
        if (!file.exists()) {
            this.setErrorMessage(NLS.bind((String)"{0} was not found.", (Object)file));
            return false;
        }
        if (!file.canExecute()) {
            this.setErrorMessage(NLS.bind((String)"{0} does not have execute permissions.", (Object)file));
            return false;
        }
        return true;
    }

    private String findOCLocation() {
        String location = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            String[] paths;
            String[] stringArray = paths = StringUtils.split((String)System.getenv("PATH"), (String)";");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                Collection files = FileUtils.listFiles((File)new File(path), (IOFileFilter)new IOFileFilter(){

                    public boolean accept(File file) {
                        return OC_BINARY_NAME.equals(file.getName());
                    }

                    public boolean accept(File dir, String name) {
                        return OC_BINARY_NAME.equals(name);
                    }
                }, null);
                if (files.size() > 0) {
                    location = ((File)files.iterator().next()).toString();
                    break;
                }
                ++n2;
            }
        } else {
            String path = (String)ThreadUtils.runWithTimeout((long)10000L, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Process process = null;
                    try {
                        process = new ProcessBuilder("which", OC_BINARY_NAME).start();
                        process.waitFor();
                        if (process.exitValue() == 0) {
                            String string = IOUtils.toString((InputStream)process.getInputStream());
                            return string;
                        }
                    }
                    catch (IOException e) {
                        OpenShiftUIActivator.getDefault().getLogger().logError("Could not run 'which' command", (Throwable)e);
                    }
                    finally {
                        if (process != null) {
                            process.destroy();
                        }
                    }
                    return null;
                }
            });
            if (!StringUtils.isEmpty((String)path)) {
                location = path;
            }
        }
        return StringUtils.trim((String)location);
    }
}

