/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.portforwading;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.common.ui.console.ConsoleUtils;

public class PortForwardingWizardModel
extends ObservablePojo {
    public static final String PROPERTY_FORWARDABLE_PORTS = "forwardablePorts";
    public static final String PROPERTY_PORT_FORWARDING = "portForwarding";
    public static final String PROPERTY_USE_FREE_PORTS = "useFreePorts";
    private Boolean useFreePorts = Boolean.FALSE;
    private final IPod pod;
    private final ConsoleListener consoleListener = new ConsoleListener();
    private List<IPortForwardable.PortPair> ports = new ArrayList<IPortForwardable.PortPair>();

    public PortForwardingWizardModel(IPod pod) {
        this.pod = pod;
        for (IPort port : pod.getContainerPorts()) {
            this.ports.add(new IPortForwardable.PortPair(port));
        }
    }

    public final String getPodName() {
        return this.pod.getName();
    }

    public boolean getPortForwarding() {
        return (Boolean)this.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPortForwardable, Boolean>(){

            public Boolean visit(IPortForwardable capability) {
                return capability.isForwarding();
            }
        }, (Object)Boolean.FALSE);
    }

    public List<IPortForwardable.PortPair> getForwardablePorts() {
        return Collections.unmodifiableList(this.ports);
    }

    public void startPortForwarding() {
        this.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPortForwardable, Object>(){

            public Object visit(IPortForwardable cap) {
                if (cap.isForwarding()) {
                    return null;
                }
                MessageConsole console = ConsoleUtils.findMessageConsole((String)PortForwardingWizardModel.this.getMessageConsoleName());
                PortForwardingWizardModel.this.consoleListener.setCapability(cap);
                ConsoleUtils.registerConsoleListener((IConsoleListener)PortForwardingWizardModel.this.consoleListener);
                MessageConsoleStream stream = console.newMessageStream();
                stream.println("Starting port-forwarding...");
                for (IPortForwardable.PortPair port : PortForwardingWizardModel.this.ports) {
                    stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()}));
                }
                cap.forwardPorts(PortForwardingWizardModel.this.ports.toArray(new IPortForwardable.PortPair[0]));
                stream.println("done.");
                ConsoleUtils.displayConsoleView((IConsole)console);
                PortForwardingWizardModel.this.firePropertyChange(PortForwardingWizardModel.PROPERTY_PORT_FORWARDING, false, PortForwardingWizardModel.this.getPortForwarding());
                return null;
            }
        }, null);
    }

    private String getMessageConsoleName() {
        return NLS.bind((String)"Port forwarding to pod {0} ({1})", (Object)this.pod.getName(), (Object)this.pod.getNamespace());
    }

    public void stopPortForwarding() {
        this.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPortForwardable, Object>(){

            public Object visit(IPortForwardable cap) {
                if (!cap.isForwarding()) {
                    return null;
                }
                try {
                    MessageConsole console = ConsoleUtils.findMessageConsole((String)PortForwardingWizardModel.this.getMessageConsoleName());
                    MessageConsoleStream stream = console.newMessageStream();
                    stream.println("Stopping port-forwarding...");
                    cap.stop();
                    for (IPortForwardable.PortPair port : PortForwardingWizardModel.this.ports) {
                        stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()}));
                    }
                    stream.println("done.");
                    ConsoleUtils.displayConsoleView((IConsole)console);
                    PortForwardingWizardModel.this.firePropertyChange(PortForwardingWizardModel.PROPERTY_PORT_FORWARDING, true, PortForwardingWizardModel.this.getPortForwarding());
                    return null;
                }
                finally {
                    ConsoleUtils.deregisterConsoleListener((IConsoleListener)PortForwardingWizardModel.this.consoleListener);
                }
            }
        }, null);
    }

    public Boolean getUseFreePorts() {
        return this.useFreePorts;
    }

    public void setUseFreePorts(Boolean useFreePorts) {
        if (!this.getPortForwarding()) {
            this.updateLocalPortBindings(useFreePorts);
        }
        this.useFreePorts = useFreePorts;
        this.firePropertyChange(PROPERTY_USE_FREE_PORTS, this.useFreePorts, this.useFreePorts);
    }

    private void updateLocalPortBindings(boolean useFreePorts) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (IPortForwardable.PortPair port : this.ports) {
            if (useFreePorts) {
                port.setLocalPort(SocketUtil.findFreePort());
                continue;
            }
            port.setLocalPort(port.getRemotePort());
            String key = this.computeKey(port);
            while (bindings.contains(key)) {
                port.setLocalPort(SocketUtil.findFreePort());
                key = this.computeKey(port);
            }
            bindings.add(key);
        }
    }

    private String computeKey(IPortForwardable.PortPair port) {
        return "127.0.0.1:" + port.getLocalPort();
    }

    private class ConsoleListener
    implements IConsoleListener {
        private IPortForwardable cap;

        private ConsoleListener() {
        }

        public void setCapability(IPortForwardable cap) {
            this.cap = cap;
        }

        public void consolesRemoved(IConsole[] consoles) {
            String messageConsoleName = PortForwardingWizardModel.this.getMessageConsoleName();
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals(messageConsoleName)) {
                    try {
                        this.cap.stop();
                        return;
                    }
                    finally {
                        ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                    }
                }
                ++n2;
            }
        }

        public void consolesAdded(IConsole[] consoles) {
        }
    }
}

