/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModel;

public class RefreshResourcesJob
extends AbstractDelegatingMonitorJob {
    private IResourcesModel model;
    private boolean resourcesAdded;

    public RefreshResourcesJob(IResourcesModel model, boolean resourcesAdded) {
        super("Refresh Resources Job");
        this.model = model;
        this.resourcesAdded = true;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refreshing OpenShift resources...", -1);
            Collection<IResource> resources = this.model.getResources();
            if (resources == null || resources.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                for (IResource resource : resources) {
                    Connection connection;
                    if ("Status".equals(resource.getKind()) || (connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource)) == null) continue;
                    IResource newValue = connection.getResource(resource);
                    IResource oldValue = this.resourcesAdded ? null : resource;
                    ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection, "openshift.resource", (Object)oldValue, (Object)newValue);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.jboss.tools.openshift.ui", "Exception refreshing resources", (Throwable)e);
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

