/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class DeleteResourceJob
extends AbstractDelegatingMonitorJob {
    private IResource resource;

    public DeleteResourceJob(IResource resource) {
        super("Delete Resource Job");
        this.resource = resource;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Delete Resource", -1);
            Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)this.resource);
            if (connection != null) {
                connection.deleteResource(this.resource);
                ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection, "openshift.resource", (Object)this.resource, null);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OpenShiftException e) {
            Status status = new Status(4, "org.jboss.tools.openshift.ui", NLS.bind((String)"Error deleting {0} named  {1}.", (Object)this.resource.getKind(), (Object)this.resource.getName()), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

