/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.job.IResourcesModel;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;

public class RefreshResourceHandler
extends AbstractHandler {
    private static final String FAILED_TO_REFRESH_ELEMENT = "Failed to refresh element";
    private static final String LOADING_OPEN_SHIFT_INFORMATIONS = "Loading OpenShift information...";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object resource = this.getResource(selection);
        if (resource != null) {
            this.refresh(resource);
        }
        return null;
    }

    private Object getResource(ISelection selection) {
        Object resource = UIUtils.getFirstElement((ISelection)selection, IRefreshable.class);
        if (resource == null) {
            resource = UIUtils.getFirstElement((ISelection)selection, IConnection.class);
        }
        if (resource == null) {
            resource = UIUtils.getFirstElement((ISelection)selection, IResource.class);
        }
        return resource;
    }

    private void refresh(Object element) {
        Job job = element instanceof IResource ? this.createRefreshResourceJob(element) : this.createRefreshRefreshableJob(element);
        job.schedule();
    }

    private Job createRefreshRefreshableJob(final Object element) {
        final IConnection connection = this.getConnection(element);
        return new AbstractDelegatingMonitorJob(LOADING_OPEN_SHIFT_INFORMATIONS){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(RefreshResourceHandler.LOADING_OPEN_SHIFT_INFORMATIONS, -1);
                        if (element instanceof IRefreshable) {
                            ((IRefreshable)element).refresh();
                            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged(connection);
                        }
                    }
                    catch (OpenShiftException e) {
                        OpenShiftCommonUIActivator.getDefault().getLogger().logError(RefreshResourceHandler.FAILED_TO_REFRESH_ELEMENT, (Throwable)e);
                        Status status = new Status(4, "org.jboss.tools.openshift.ui", RefreshResourceHandler.FAILED_TO_REFRESH_ELEMENT, (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
    }

    private Job createRefreshResourceJob(final Object element) {
        return new RefreshResourcesJob(new IResourcesModel(){

            @Override
            public Collection<IResource> getResources() {
                return Arrays.asList((IResource)element);
            }
        }, false);
    }

    private IConnection getConnection(Object resource) {
        if (resource instanceof IConnection) {
            return (IConnection)resource;
        }
        if (resource instanceof IResource) {
            return ConnectionsRegistryUtil.getConnectionFor((IResource)((IResource)resource));
        }
        return null;
    }
}

