/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IPod;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.ui.wizard.OkButtonWizardDialog;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.portforwading.PortForwardingWizard;
import org.jboss.tools.openshift.internal.ui.portforwading.PortForwardingWizardModel;

public class PortForwardingHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String location = OpenShiftUIActivator.getDefault().getCorePreferenceStore().getString("openshift.cli.location");
        if (StringUtils.isBlank((String)location)) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Unknown binary location", (String)"The location to the OpenShift 'oc' binary must be set in your Eclipse preferences.");
            return null;
        }
        System.setProperty("openshift.restclient.oc.location", location);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IPod pod = (IPod)UIUtils.getFirstElement((ISelection)selection, IPod.class);
        if (pod == null) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No pod selection", (String)"No pod was selected for port forwarding.");
        }
        this.openDialog(pod);
        return null;
    }

    private void openDialog(IPod pod) {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        OkButtonWizardDialog dialog = new OkButtonWizardDialog(shell, (IWizard)new PortForwardingWizard(new PortForwardingWizardModel(pod)));
        dialog.setMinimumPageSize(700, 400);
        dialog.create();
        dialog.open();
    }
}

