/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;

public class OpenInWebBrowserHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IRoute route = (IRoute)UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IRoute.class);
        if (route != null) {
            this.openBrowser(route);
        } else {
            final IProject project = (IProject)UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IProject.class);
            if (project != null) {
                new UIUpdatingJob(NLS.bind((String)"Loading routes for project {0}", (Object)project.getName())){
                    private List<IRoute> routes;

                    protected IStatus run(IProgressMonitor monitor) {
                        this.routes = project.getResources("Route");
                        return Status.OK_STATUS;
                    }

                    protected IStatus updateUI(IProgressMonitor monitor) {
                        if (this.routes == null || this.routes.isEmpty()) {
                            return OpenShiftUIActivator.statusFactory().cancelStatus("Could not find a route that points to an url to show in a browser.");
                        }
                        if (this.routes.size() > 1) {
                            SelectRouteDialog routeDialog = new SelectRouteDialog(this.routes, HandlerUtil.getActiveShell((ExecutionEvent)event));
                            if (routeDialog.open() == 0) {
                                OpenInWebBrowserHandler.this.openBrowser(routeDialog.getSelectedRoute());
                            }
                        } else {
                            OpenInWebBrowserHandler.this.openBrowser(this.routes.get(0));
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                return OpenShiftUIActivator.statusFactory().cancelStatus("Could not find a route that points to an url to show in a browser.");
            }
        }
        return Status.OK_STATUS;
    }

    private void openBrowser(IRoute route) {
        if (route == null || route.getURL() == null || route.getURL().isEmpty()) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Could not find a route that points to an url to show in a browser.");
            return;
        }
        new BrowserUtility().checkedCreateInternalBrowser(route.getURL(), "", "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
    }
}

