/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.explorer;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;
import org.jboss.tools.openshift.internal.ui.explorer.ResourceGrouping;

public class OpenShiftExplorerContentProvider
extends BaseExplorerContentProvider {
    private static final String[] groupings = new String[]{"BuildConfig", "DeploymentConfig", "Service", "Pod", "ReplicationController", "Build", "ImageStream", "Route"};
    private Map<IProject, List<ResourceGrouping>> groupMap = new HashMap<IProject, List<ResourceGrouping>>();

    protected void handleConnectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
        if (!(connection instanceof Connection)) {
            return;
        }
        if ("openshift.resource".equals(property)) {
            if (oldValue == null && newValue != null) {
                IResource resource = (IResource)newValue;
                this.refreshGrouping(this.groupMap.get(resource.getProject()), resource.getKind());
                ResourceGrouping group = this.getResourceGrouping(this.groupMap.get(resource.getProject()), resource.getKind());
                this.expand(group, 1);
            } else if (oldValue != null && newValue == null) {
                IResource resource = (IResource)oldValue;
                this.refreshGrouping(this.groupMap.get(resource.getProject()), resource.getKind());
            } else {
                this.refreshViewer(newValue);
            }
        } else if ("openshift.projects".equals(property)) {
            this.handleProjectChanges((Connection)connection, oldValue, newValue);
        } else {
            super.handleConnectionChanged(connection, property, oldValue, newValue);
        }
    }

    private void handleProjectChanges(Connection connection, Object oldValue, Object newValue) {
        List newProjects = (List)newValue;
        List oldProjects = (List)oldValue;
        final ArrayList added = new ArrayList();
        final ArrayList removed = new ArrayList();
        ListDiff diffs = Diffs.computeListDiff((List)oldProjects, (List)newProjects);
        diffs.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                IProject project = (IProject)element;
                removed.add(project);
                OpenShiftExplorerContentProvider.this.groupMap.remove(project);
            }

            public void handleAdd(int index, Object element) {
                IProject project = (IProject)element;
                added.add(project);
            }
        });
        this.removeChildrenFromViewer(connection, removed.toArray());
        this.addChildrenToViewer(connection, added.toArray());
    }

    protected void handleConnectionRemoved(IConnection connection) {
        if (!(connection instanceof Connection)) {
            return;
        }
        for (IProject project : this.groupMap.keySet()) {
            Connection conn = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
            if (!connection.equals(conn)) continue;
            this.groupMap.remove(project);
            break;
        }
        super.handleConnectionRemoved(connection);
    }

    private void refreshGrouping(List<ResourceGrouping> groupings, String kind) {
        if (groupings == null || groupings.size() == 0) {
            return;
        }
        ResourceGrouping group = this.getResourceGrouping(groupings, kind);
        if (group != null) {
            group.refresh();
        }
    }

    private ResourceGrouping getResourceGrouping(List<ResourceGrouping> groupings, String kind) {
        if (groupings == null || groupings.size() == 0) {
            return null;
        }
        for (ResourceGrouping group : groupings) {
            if (!kind.equals(group.getKind())) continue;
            return group;
        }
        return null;
    }

    public Object[] getExplorerElements(Object parentElement) {
        if (parentElement instanceof ConnectionsRegistry) {
            ConnectionsRegistry registry = (ConnectionsRegistry)parentElement;
            return registry.getAll(Connection.class).toArray();
        }
        if (parentElement instanceof Connection) {
            return ((Connection)parentElement).getResources("Project").toArray();
        }
        return new Object[0];
    }

    public Object[] getChildrenFor(Object parentElement) {
        try {
            if (parentElement instanceof Connection) {
                Connection connection = (Connection)parentElement;
                return connection.getResources("Project").toArray();
            }
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                ArrayList<ResourceGrouping> groups = new ArrayList<ResourceGrouping>(groupings.length);
                String[] stringArray = groupings;
                int n = groupings.length;
                int n2 = 0;
                while (n2 < n) {
                    String kind = stringArray[n2];
                    final ResourceGrouping grouping = new ResourceGrouping(kind, project);
                    grouping.setRefreshable(new IRefreshable(){

                        public void refresh() {
                            OpenShiftExplorerContentProvider.this.refreshViewer(grouping);
                        }
                    });
                    groups.add(grouping);
                    ++n2;
                }
                this.groupMap.put(project, groups);
                return groups.toArray();
            }
            if (parentElement instanceof ResourceGrouping) {
                ResourceGrouping group = (ResourceGrouping)parentElement;
                return group.getProject().getResources(group.getKind()).toArray();
            }
        }
        catch (OpenShiftException e) {
            this.addException(parentElement, (Exception)((Object)e));
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        return element instanceof ConnectionsRegistry || element instanceof IConnection || element instanceof IProject || element instanceof ResourceGrouping;
    }
}

