/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.dialog;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IStatus;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public class ResourceSummaryLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public String getText(Object arg) {
        if (arg instanceof IResource) {
            IResource resource = (IResource)arg;
            if (this.isFailedStatus(resource)) {
                return StringUtils.capitalize((String)((IStatus)resource).getMessage());
            }
            return NLS.bind((String)"{0} - {1}", (Object)resource.getKind(), (Object)resource.getName());
        }
        return arg.toString();
    }

    public Image getImage(Object arg) {
        if (arg instanceof IResource) {
            IResource resource = (IResource)arg;
            if (this.isFailedStatus(resource)) {
                return OpenShiftCommonImages.ERROR;
            }
            return OpenShiftCommonImages.OK_IMG;
        }
        return null;
    }

    public StyledString getStyledText(Object arg) {
        if (arg instanceof IResource) {
            IResource resource = (IResource)arg;
            StyledString text = new StyledString();
            if (this.isFailedStatus(resource)) {
                text.append(((IStatus)resource).getMessage());
            } else {
                text.append(org.jboss.tools.openshift.common.core.utils.StringUtils.humanize((String)resource.getKind().toString()));
                text.append(resource.getName(), StyledString.QUALIFIER_STYLER);
            }
            return text;
        }
        return null;
    }

    private boolean isFailedStatus(IResource resource) {
        return "Status".equals(resource.getKind()) && ((IStatus)resource).isFailure();
    }
}

