/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui;

import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.foundation.ui.plugin.BaseUIPlugin;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.internal.common.ui.connection.CredentialsPrompter;
import org.jboss.tools.openshift.internal.ui.wizard.connection.SSLCertificateCallback;
import org.osgi.framework.BundleContext;

public class OpenShiftUIActivator
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.openshift.ui";
    private static OpenShiftUIActivator plugin;
    private IPreferenceStore corePreferenceStore;

    public IPluginLog getLogger() {
        return this.pluginLogInternal();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        OpenShiftCoreUIIntegration.getInstance().setSSLCertificateAuthorization((ISSLCertificateCallback)new SSLCertificateCallback());
        OpenShiftCoreUIIntegration.getInstance().setCredentialPrompter((ICredentialsPrompter)new CredentialsPrompter());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static OpenShiftUIActivator getDefault() {
        return plugin;
    }

    public static StatusFactory statusFactory() {
        return OpenShiftUIActivator.getDefault().statusFactoryInternal();
    }

    public InputStream getPluginFile(String file) {
        try {
            URL url = new URL(plugin.getBundle().getEntry("/"), file);
            return url.openStream();
        }
        catch (Exception e) {
            this.getLogger().logError((Throwable)e);
            throw new OpenShiftException((Throwable)e, "Exception trying to load plugin file: {0}", new Object[]{file});
        }
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.jboss.tools.openshift.core");
        }
        return this.corePreferenceStore;
    }
}

