/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.internal.common.ui.ImageRepository;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class OpenShiftImages {
    private static final String ICONS_FOLDER = "icons/";
    private static final String ICON_NAME_PREFIX = "icon-";
    private static final ImageRepository repo = new ImageRepository("icons/", (Plugin)OpenShiftUIActivator.getDefault(), OpenShiftUIActivator.getDefault().getImageRegistry());
    public static final ImageDescriptor BLOCKS = repo.create("blocks.png");
    public static final Image BLOCKS_IMG = repo.getImage("blocks.png");
    public static final ImageDescriptor BUILDCONFIG = repo.create("buildconfig.png");
    public static final Image BUILDCONFIG_IMG = repo.getImage("buildconfig.png");
    public static final ImageDescriptor GEAR = repo.create("gear.png");
    public static final Image GEAR_IMG = repo.getImage("gear.png");
    public static final ImageDescriptor LAYER = repo.create("layer.png");
    public static final Image LAYER_IMG = repo.getImage("layer.png");
    private static Map<String, ImageDescriptor> descriptorsByName = new HashMap<String, ImageDescriptor>();

    public static final Image getAppImage(String name) {
        if (name.startsWith(ICON_NAME_PREFIX)) {
            name = name.substring(ICON_NAME_PREFIX.length());
        }
        String imagePath = NLS.bind((String)"apps/{0}.png", (Object)name);
        if (!descriptorsByName.containsKey(name)) {
            descriptorsByName.put(name, repo.create(imagePath));
        }
        return (Image)ObjectUtils.defaultIfNull((Object)repo.getImage(imagePath), (Object)BLOCKS_IMG);
    }
}

