/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnZip {
    public static void extract(File file, File destination) throws IOException {
        ZipInputStream in = null;
        OutputStream out = null;
        try {
            in = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String outFilename = entry.getName();
                File extracted = new File(destination, outFilename);
                if (entry.isDirectory()) {
                    extracted.mkdirs();
                    continue;
                }
                out = new FileOutputStream(extracted);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                if (!extracted.getParent().contains("/bin")) continue;
                extracted.setExecutable(true);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

