/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.html;

import tern.server.protocol.html.IState;
import tern.server.protocol.html.MultiState;
import tern.server.protocol.html.Region;
import tern.server.protocol.html.RegionType;
import tern.server.protocol.html.ScriptTagRegion;
import tern.server.protocol.html.State;

public class HtmlHelper {
    public static String extractJS(String html) {
        return HtmlHelper.extractJS(html, ScriptTagRegion.SCRIPT_TAG);
    }

    public static String extractJS(String html, ScriptTagRegion ... tagRegions) {
        IState state = HtmlHelper.createState(tagRegions);
        StringBuilder s = new StringBuilder();
        char[] chars = html.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    s.append(c);
                    break;
                }
                default: {
                    Region matchedRegion = state.update(c);
                    if (matchedRegion == null) {
                        if (state.isNextRegionToFindType(RegionType.END_SCRIPT)) {
                            s.append(c);
                            break;
                        }
                        s.append(' ');
                        break;
                    }
                    if (matchedRegion.getType().equals((Object)RegionType.END_SCRIPT)) {
                        int length = matchedRegion.getLength();
                        s = s.replace(i - length, i, matchedRegion.getSpaces());
                        state.reset();
                    }
                    s.append(' ');
                }
            }
            ++i;
        }
        return s.toString();
    }

    private static IState createState(ScriptTagRegion[] tagRegions) {
        if (tagRegions.length == 1) {
            return new State(tagRegions[0]);
        }
        return new MultiState(tagRegions);
    }
}

