/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.completions;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.completions.TernCompletionProposalRec;
import tern.utils.StringUtils;

public class TernCompletionsResultProcessor
implements ITernResultProcessor<ITernCompletionCollector> {
    protected static final String NAME_PROPERTY = "name";
    protected static final String DISPLAY_NAME_PROPERTY = "displayName";
    protected static final String TYPE_PROPERTY = "type";
    protected static final String DOC_PROPERTY = "doc";
    protected static final String URL_PROPERTY = "url";
    protected static final String ORIGIN_PROPERTY = "origin";
    protected static final String IS_PROPERTY_PROPERTY = "isProperty";
    protected static final String IS_OBJECT_KEY_PROPERTY = "isObjectKey";
    public static final TernCompletionsResultProcessor INSTANCE = new TernCompletionsResultProcessor();

    @Override
    public void process(TernDoc doc, IJSONObjectHelper objectHelper, Object jsonObject, ITernCompletionCollector collector) {
        Long startCh = objectHelper.getCh(jsonObject, "start");
        Long endCh = objectHelper.getCh(jsonObject, "end");
        if (startCh != null && endCh != null) {
            int cfr_ignored_0 = endCh.intValue() - startCh.intValue();
        }
        boolean isProperty = StringUtils.asBoolean(objectHelper.getText(jsonObject, IS_PROPERTY_PROPERTY), false);
        boolean isObjectKey = StringUtils.asBoolean(objectHelper.getText(jsonObject, IS_OBJECT_KEY_PROPERTY), false);
        Iterable<Object> completions = objectHelper.getList(jsonObject, "completions");
        if (completions != null) {
            for (Object value : completions) {
                if (objectHelper.isString(value)) {
                    collector.addProposal(new TernCompletionProposalRec(objectHelper.getText(value), objectHelper.getText(value), null, null, null, null, startCh != null ? startCh.intValue() : 0, endCh != null ? endCh.intValue() : 0, isProperty, isObjectKey), value, objectHelper);
                    continue;
                }
                this.addProposal(objectHelper, value, startCh != null ? startCh.intValue() : 0, endCh != null ? endCh.intValue() : 0, isProperty, isObjectKey, collector);
            }
        }
    }

    protected void addProposal(IJSONObjectHelper objectHelper, Object completion, int start, int end, boolean isProperty, boolean isObjectKey, ITernCompletionCollector collector) {
        String name = objectHelper.getText(completion, NAME_PROPERTY);
        String displayName = objectHelper.getText(completion, DISPLAY_NAME_PROPERTY);
        String type = objectHelper.getText(completion, TYPE_PROPERTY);
        String doc = objectHelper.getText(completion, DOC_PROPERTY);
        String url = objectHelper.getText(completion, URL_PROPERTY);
        String origin = objectHelper.getText(completion, ORIGIN_PROPERTY);
        collector.addProposal(new TernCompletionProposalRec(name, displayName, type, doc, url, origin, start, end, isProperty, isObjectKey), completion, objectHelper);
    }
}

