/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import java.util.ArrayList;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.utils.StringUtils;

public enum TernPlugin implements ITernPlugin
{
    aui15("aui", "1.5.x"),
    aui2("aui", "2.0.x"),
    angular("tern/plugin/angular"),
    chrome_apps("chrome-apps", "chrome-apps", null, null),
    component("tern/plugin/component"),
    ckeditor_4_4_x("ckeditor", "4.4.x"),
    closure(""),
    cordovajs("tern/plugin/cordovajs"),
    doc_comment("tern/plugin/doc_comment"),
    dojotoolkit_1_6("dojotoolkit", "1.6", true),
    dojotoolkit_1_8("dojotoolkit", "1.8", true),
    dojotoolkit_1_9("dojotoolkit", "1.9", true),
    extjs_4_2_1("extjs", "4.2.1", true),
    extjs_5_0_0("extjs", "5.0.0", true),
    guess_types("guess-types", "guess-types", null, null),
    grunt("tern/plugin/grunt"),
    gulp("tern/plugin/gulp"),
    gas("tern/plugin/gas"),
    liferay("tern/plugin/liferay"),
    node_express("node-express", "node-express", null, null),
    node_mongodb_native("node-mongodb-native", "node-mongodb-native", null, null),
    node_mongoose("node-mongoose", "node-mongoose", null, null),
    node("tern/plugin/node"),
    tabris("tern-tabris"),
    meteor("tern/plugin/meteor"),
    qooxdoo_4_1("qooxdoo", "4.1", true),
    requirejs("tern/plugin/requirejs"),
    yui3("yui", "3"),
    lint(null, null, null, null, true),
    eslint(null, null, null, null, true),
    jshint(null, null, null, null, true),
    jscs(null, null, null, null, true);

    private static final ITernPlugin[] linters;
    private final String name;
    private final String type;
    private final String version;
    private final String path;
    private final boolean linter;
    private TernModuleMetadata metadata;

    static {
        linters = TernPlugin.createLinters();
    }

    private static ITernPlugin[] createLinters() {
        TernPlugin[] plugins;
        ArrayList<TernPlugin> linters = new ArrayList<TernPlugin>();
        TernPlugin[] ternPluginArray = plugins = TernPlugin.values();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            TernPlugin plugin = ternPluginArray[n2];
            if (plugin.isLinter()) {
                linters.add(plugin);
            }
            ++n2;
        }
        return linters.toArray(ITernPlugin.EMPTY_PLUGIN);
    }

    private TernPlugin(String path) {
        this(null, null, null, path);
    }

    private TernPlugin(String type, String version) {
        this(type, version, false);
    }

    private TernPlugin(String type, String version, boolean oldName) {
        this(type + (oldName ? "_" : "") + version, type, version, "tern/plugin/" + type + "_" + version);
    }

    private TernPlugin(String name, String type, String version, String path) {
        this(name, type, version, path, false);
    }

    private TernPlugin(String name, String type, String version, String path, boolean linter) {
        this.name = name != null ? name : this.name();
        this.type = type != null ? type : this.name();
        this.path = path;
        this.version = version;
        this.linter = linter;
        this.metadata = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.Plugin;
    }

    public static ITernPlugin getTernPlugin(String name) {
        TernPlugin[] plugins = TernPlugin.values();
        TernPlugin plugin = null;
        int i = 0;
        while (i < plugins.length) {
            plugin = plugins[i];
            if (plugin.getName().equals(name)) {
                return plugin;
            }
            ++i;
        }
        return null;
    }

    public static ITernPlugin[] getLinters() {
        return linters;
    }

    @Override
    public TernModuleMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = TernModuleMetadataManager.getInstance().getMetadata(this.getType());
        }
        return this.metadata;
    }

    @Override
    public boolean isLinter() {
        return this.linter;
    }

    @Override
    public String getOrigin() {
        String origin = null;
        TernModuleMetadata metadata = this.getMetadata();
        if (metadata != null) {
            origin = metadata.getOrigin();
        }
        return !StringUtils.isEmpty(origin) ? origin : this.getName();
    }
}

