/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.server.ITernDef;
import tern.server.ModuleType;
import tern.utils.StringUtils;

public enum TernDef implements ITernDef
{
    browser("tern/defs/browser.json"),
    chai("tern/defs/chai.json"),
    ecma5(null, "ecma", "5", "tern/defs/ecma5.json"),
    ecma6(null, "ecma", "6", "tern/defs/ecma5.json"),
    jquery("tern/defs/jquery.json"),
    underscore("tern/defs/underscore.json"),
    titanium("titanium.json");

    private final String name;
    private final String type;
    private final String version;
    private final String path;
    private TernModuleMetadata metadata;

    private TernDef(String path) {
        this(null, null, null, path);
    }

    private TernDef(String name, String type, String version, String path) {
        this.name = name != null ? name : this.name();
        this.type = type != null ? type : this.name();
        this.version = version;
        this.path = path;
        this.metadata = null;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.name();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.Def;
    }

    public static ITernDef getTernDef(String name) {
        TernDef[] defs = TernDef.values();
        TernDef def = null;
        int i = 0;
        while (i < defs.length) {
            def = defs[i];
            if (def.getName().equals(name)) {
                return def;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TernModuleMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = TernModuleMetadataManager.getInstance().getMetadata(this.getType());
        }
        return this.metadata;
    }

    @Override
    public String getOrigin() {
        String origin = null;
        TernModuleMetadata metadata = this.getMetadata();
        if (metadata != null) {
            origin = metadata.getOrigin();
        }
        return !StringUtils.isEmpty(origin) ? origin : this.getName();
    }
}

