/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tern.ITernProject;
import tern.TernException;
import tern.repository.ITernRepository;
import tern.server.AbstractTernServer;
import tern.server.ITernModule;
import tern.utils.IOUtils;

public abstract class AbstractScriptEngineTernServer
extends AbstractTernServer {
    private final String[] ACORN_SCRIPTS = new String[]{"node_modules/acorn/dist/acorn.js", "node_modules/acorn/dist/acorn_loose.js", "node_modules/acorn/dist/walk.js"};
    private final String[] TERN_SCRIPTS = new String[]{"lib/signal.js", "lib/tern.js", "lib/def.js", "lib/comment.js", "lib/infer.js"};

    public AbstractScriptEngineTernServer(ITernProject project) {
        super(project);
    }

    protected TernResources loadTern() throws TernException {
        ITernRepository repository = this.getProject().getRepository();
        if (repository == null) {
            throw new TernException("Tern repository must be initialized.");
        }
        try {
            JsonObject plugins;
            ArrayList<TernResource> scripts = new ArrayList<TernResource>();
            ArrayList<TernResource> defs = new ArrayList<TernResource>();
            int i = 0;
            while (i < this.ACORN_SCRIPTS.length) {
                scripts.add(this.getResource(new File(repository.getTernBaseDir(), this.ACORN_SCRIPTS[i])));
                ++i;
            }
            i = 0;
            while (i < this.TERN_SCRIPTS.length) {
                scripts.add(this.getResource(new File(repository.getTernBaseDir(), this.TERN_SCRIPTS[i])));
                ++i;
            }
            JsonArray libs = this.getProject().getLibs();
            if (libs != null) {
                ITernModule module = null;
                File defFile = null;
                for (JsonValue lib : libs) {
                    module = repository.getModule(lib.asString());
                    if (module == null || (defFile = repository.getFile(module)) == null || !defFile.exists()) continue;
                    defs.add(this.getResource(defFile));
                }
            }
            if ((plugins = this.getProject().getPlugins()) != null) {
                ITernModule module = null;
                File pluginFile = null;
                List names = plugins.names();
                for (String name : names) {
                    module = repository.getModule(name);
                    if (module == null || (pluginFile = repository.getFile(module)) == null || !pluginFile.exists()) continue;
                    scripts.add(this.getResource(pluginFile));
                }
            }
            return new TernResources(scripts, defs);
        }
        catch (IOException e) {
            throw new TernException(e);
        }
    }

    protected TernResource getResource(File scriptFile) throws IOException {
        String script = this.getScriptContent(scriptFile);
        String filename = this.getFilename(scriptFile);
        return new TernResource(script, filename);
    }

    protected String getScriptContent(File scriptFile) throws IOException, FileNotFoundException {
        return IOUtils.toString(new FileInputStream(scriptFile), "UTF-8");
    }

    protected String getFilename(File scriptFile) {
        try {
            return scriptFile.getCanonicalPath().toString();
        }
        catch (Throwable throwable) {
            return scriptFile.getPath().toString();
        }
    }

    protected class TernResource {
        private final String content;
        private final String filename;

        public TernResource(String content, String filename) {
            this.content = content;
            this.filename = filename;
        }

        public String getContent() {
            return this.content;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    protected class TernResources {
        private final List<TernResource> scripts;
        private final List<TernResource> defs;

        public TernResources(List<TernResource> scripts, List<TernResource> defs) {
            this.scripts = scripts;
            this.defs = defs;
        }

        public List<TernResource> getScripts() {
            return this.scripts;
        }

        public List<TernResource> getDefs() {
            return this.defs;
        }

        public String getDefsAsString() {
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i < this.defs.size()) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.defs.get(i).getContent());
                ++i;
            }
            return s.toString();
        }
    }
}

