/*
 * Decompiled with CFR 0.152.
 */
package tern.scriptpath.impl.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tern.ITernFile;
import tern.ITernProject;
import tern.internal.resources.InternalTernResourcesManager;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.AbstractTernFileScriptPath;
import tern.scriptpath.impl.dom.DOMAbsoluteURLScriptResource;
import tern.scriptpath.impl.dom.DOMContentScriptResource;
import tern.scriptpath.impl.dom.DOMRelativeURLScriptResource;
import tern.utils.StringUtils;

public class DOMElementsScriptPath
extends AbstractTernFileScriptPath {
    private static final String SCRIPT_ELT = "script";
    private static final String HTTP_ATTR = "http";
    private static final String SRC_ATTR = "src";

    public DOMElementsScriptPath(ITernProject project, ITernFile file, String external) {
        super(project, file, external);
    }

    @Override
    public List<ITernScriptResource> getScriptResources() {
        ArrayList<ITernScriptResource> resources = new ArrayList<ITernScriptResource>();
        Document document = this.getDocument();
        if (document != null) {
            int localScriptNb = 0;
            Element scriptElt = null;
            String src = null;
            NodeList scripts = this.getScriptNodes(document);
            int i = 0;
            while (i < scripts.getLength()) {
                scriptElt = (Element)scripts.item(i);
                src = scriptElt.getAttribute(SRC_ATTR);
                ITernScriptResource resource = StringUtils.isEmpty(src) ? this.createDOMContentScriptResource(localScriptNb++) : (src.startsWith(HTTP_ATTR) ? new DOMAbsoluteURLScriptResource(src) : this.createDOMRelativeURLScriptResource(src));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
        }
        return resources;
    }

    protected NodeList getScriptNodes(Document document) {
        return document.getElementsByTagName(SCRIPT_ELT);
    }

    protected ITernScriptResource createDOMAbsoluteURLScriptResource(String src) {
        return new DOMAbsoluteURLScriptResource(src);
    }

    protected ITernScriptResource createDOMRelativeURLScriptResource(String relativePath) {
        return new DOMRelativeURLScriptResource(this.getFile(), relativePath);
    }

    protected ITernScriptResource createDOMContentScriptResource(int localScriptNb) {
        return new DOMContentScriptResource(this.getFile(), localScriptNb);
    }

    protected Document getDocument() {
        return InternalTernResourcesManager.getInstance().getDocument(this.getFile());
    }
}

