/*
 * Decompiled with CFR 0.152.
 */
package tern.scriptpath.impl;

import java.util.ArrayList;
import java.util.List;
import tern.ITernProject;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.AbstractTernScriptPath;

public class ProjectScriptPath
extends AbstractTernScriptPath {
    private final ITernProject project;
    private final List<ITernScriptResource> scripts;

    public ProjectScriptPath(ITernProject project, ITernProject ownerProject, String external) {
        super(ownerProject, ITernScriptPath.ScriptPathsType.PROJECT, external);
        this.project = project;
        this.scripts = new ArrayList<ITernScriptResource>();
    }

    public ITernProject getProject() {
        return this.project;
    }

    @Override
    public String getLabel() {
        if (this.getExternalLabel() != null) {
            return this.project.getName() + " (" + this.getExternalLabel() + ")";
        }
        return this.project.getName();
    }

    @Override
    public String getPath() {
        return this.project.getName();
    }

    @Override
    public List<ITernScriptResource> getScriptResources() {
        this.scripts.clear();
        for (ITernScriptPath scriptPath : this.project.getScriptPaths()) {
            if (scriptPath.getType() == ITernScriptPath.ScriptPathsType.PROJECT && scriptPath.getOwnerProject().equals(this.project)) continue;
            this.scripts.addAll(scriptPath.getScriptResources());
        }
        return this.scripts;
    }

    @Override
    public Object getAdapter(Class clazz) {
        return this.project.getAdapter(clazz);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 17 + this.project.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProjectScriptPath) {
            return super.equals(obj) && this.project.equals(((ProjectScriptPath)obj).project);
        }
        return false;
    }
}

