/*
 * Decompiled with CFR 0.152.
 */
package tern.resources;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import tern.ITernFile;
import tern.ITernFileSynchronizer;
import tern.ITernProject;
import tern.TernException;
import tern.internal.resources.InternalTernResourcesManager;
import tern.repository.ITernRepository;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.impl.dom.DOMElementsScriptPath;
import tern.server.ITernDef;
import tern.server.ITernPlugin;
import tern.server.ITernServer;
import tern.server.TernPlugin;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.guesstypes.ITernGuessTypesCollector;
import tern.server.protocol.guesstypes.TernGuessTypesQuery;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.type.ITernTypeCollector;
import tern.utils.IOUtils;

public class TernProject
extends JsonObject
implements ITernProject {
    private static final long serialVersionUID = 1L;
    private static final String PLUGINS_FIELD_NAME = "plugins";
    private static final String LIBS_FIELD_NAME = "libs";
    private static final String LOAD_EAGERLY_FIELD_NAME = "loadEagerly";
    private final File projectDir;
    private File ternProjectFile;
    private ITernRepository repository;
    private ITernPlugin[] linters;
    private ITernFileSynchronizer fileSynchronizer;
    private String lastTernProjectFileContent;
    private Object libLock = new Object();

    public TernProject(File projectDir) {
        this.projectDir = projectDir;
        this.ternProjectFile = new File(projectDir, ".tern-project");
        this.fileSynchronizer = InternalTernResourcesManager.getInstance().createTernFileSynchronizer(this);
    }

    @Override
    public String getName() {
        return this.projectDir.getName();
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getTernProjectFile() {
        return this.ternProjectFile;
    }

    public boolean hasModules() {
        return this.hasLibs() || this.hasPlugins();
    }

    @Override
    public void addLib(ITernDef lib) {
        this.addLib(lib.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLib(String lib) {
        Object object = this.libLock;
        synchronized (object) {
            if (!this.hasLib(lib)) {
                this.getLibs().add(lib);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLib(String lib) {
        Object object = this.libLock;
        synchronized (object) {
            JsonArray libs = this.getLibs();
            if (libs != null) {
                for (JsonValue l : libs) {
                    if (!l.isString() || !l.asString().equals(lib)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasLibs() {
        return super.get(LIBS_FIELD_NAME) != null;
    }

    @Override
    public boolean hasLib(ITernDef lib) {
        return this.hasLib(lib.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray getLibs() {
        Object object = this.libLock;
        synchronized (object) {
            JsonArray libs = (JsonArray)super.get(LIBS_FIELD_NAME);
            if (libs == null) {
                libs = new JsonArray();
                this.add(LIBS_FIELD_NAME, (JsonValue)libs);
            }
            return libs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLibs() {
        Object object = this.libLock;
        synchronized (object) {
            this.remove(LIBS_FIELD_NAME);
        }
    }

    public boolean hasPlugins() {
        return super.get(PLUGINS_FIELD_NAME) != null;
    }

    @Override
    public void addPlugin(ITernPlugin plugin) {
        this.addPlugin(plugin, null);
    }

    @Override
    public void addPlugin(ITernPlugin plugin, JsonObject options) {
        JsonObject plugins = this.getPlugins();
        if (options == null) {
            options = new JsonObject();
        }
        if (!this.hasPlugin(plugin)) {
            plugins.add(plugin.getName(), (JsonValue)options);
        } else if (!JsonHelper.isSameJson(plugins.get(plugin.getName()), options)) {
            plugins.set(plugin.getName(), (JsonValue)options);
        }
    }

    @Override
    public boolean hasPlugin(ITernPlugin plugin) {
        return this.hasPlugin(plugin.getName());
    }

    @Override
    public boolean hasPlugin(String plugin) {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        return plugins == null ? false : plugins.get(plugin) != null;
    }

    @Override
    public JsonObject getPlugins() {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        if (plugins == null) {
            plugins = new JsonObject();
            this.add(PLUGINS_FIELD_NAME, (JsonValue)plugins);
        }
        return plugins;
    }

    @Override
    public void clearPlugins() {
        this.remove(PLUGINS_FIELD_NAME);
        this.linters = null;
    }

    @Override
    public ITernPlugin[] getLinters() {
        if (this.linters == null) {
            ArrayList<ITernPlugin> plugins = new ArrayList<ITernPlugin>();
            ITernRepository repository = this.getRepository();
            if (repository != null) {
                this.addLinter(plugins, repository.getLinters());
            } else {
                this.addLinter(plugins, TernPlugin.getLinters());
            }
            this.linters = plugins.toArray(ITernPlugin.EMPTY_PLUGIN);
        }
        return this.linters;
    }

    private void addLinter(Collection<ITernPlugin> plugins, ITernPlugin[] knownLintPlugins) {
        int i = 0;
        while (i < knownLintPlugins.length) {
            ITernPlugin knownLintPlugin = knownLintPlugins[i];
            if (this.hasPlugin(knownLintPlugin) && !plugins.contains(knownLintPlugin)) {
                plugins.add(knownLintPlugin);
            }
            ++i;
        }
    }

    public void addLoadEagerlyPattern(String pattern) {
        JsonArray patterns = (JsonArray)super.get(LOAD_EAGERLY_FIELD_NAME);
        if (patterns == null) {
            patterns = new JsonArray();
            this.add(LOAD_EAGERLY_FIELD_NAME, (JsonValue)patterns);
        }
        patterns.add(pattern);
    }

    @Override
    public final void save() throws IOException {
        try {
            this.doSave();
        }
        finally {
            this.lastTernProjectFileContent = this.toString();
        }
    }

    protected void doSave() throws IOException {
        if (this.isDirty()) {
            this.getProjectDir().mkdirs();
            FileWriter writer = null;
            try {
                writer = new FileWriter(this.ternProjectFile);
                super.writeTo((Writer)writer);
            }
            finally {
                if (writer != null) {
                    IOUtils.closeQuietly(writer);
                }
            }
        }
    }

    public final void load() throws IOException {
        this.doLoad();
        this.lastTernProjectFileContent = this.toString();
    }

    protected void doLoad() throws IOException {
        if (this.ternProjectFile.exists()) {
            try {
                JsonHelper.readFrom(new FileReader(this.ternProjectFile), this);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        } else {
            this.createEmptyTernProjectFile();
        }
        this.lastTernProjectFileContent = this.toString();
    }

    protected void createEmptyTernProjectFile() throws IOException {
        this.save();
    }

    @Override
    public void handleException(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public ITernFileSynchronizer getFileSynchronizer() {
        return this.fileSynchronizer;
    }

    @Override
    public ITernServer getTernServer() {
        return null;
    }

    @Override
    public ITernFile getFile(String name) {
        return InternalTernResourcesManager.getInstance().getTernFile(this, name);
    }

    @Override
    public ITernFile getFile(Object fileObject) {
        return InternalTernResourcesManager.getInstance().getTernFile(fileObject);
    }

    @Override
    public List<ITernScriptPath> getScriptPaths() {
        return Collections.emptyList();
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass == File.class) {
            return this.getProjectDir();
        }
        return null;
    }

    protected void synchronize(TernDoc doc, JsonArray names, ITernScriptPath scriptPath, Node domNode, ITernFile file) {
        ITernFileSynchronizer synchronizer = this.getFileSynchronizer();
        synchronizer.ensureSynchronized();
        if (file != null) {
            if (doc.getQuery() != null) {
                doc.getQuery().setFile(file.getFullName(this));
            }
            if (domNode != null) {
                DOMElementsScriptPath domPath = this.createDOMElementsScriptPath(domNode, file);
                synchronizer.synchronizeScriptPath(domPath, file.getFullName(this));
            } else {
                try {
                    synchronizer.synchronizeFile(doc, file);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
            }
        }
        if (names != null) {
            synchronizer.fillSyncedFileNames(names, scriptPath);
        }
    }

    protected DOMElementsScriptPath createDOMElementsScriptPath(Node domNode, ITernFile file) {
        final Document doc = domNode.getOwnerDocument();
        return new DOMElementsScriptPath(this, file, null){

            @Override
            protected Document getDocument() {
                return doc;
            }
        };
    }

    @Override
    public void request(TernQuery query, ITernFile file, ITernCompletionCollector collector) throws IOException, TernException {
        this.request(query, null, null, null, file, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, Node domNode, ITernFile file, ITernCompletionCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchronize(doc, names, scriptPath, domNode, file);
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, ITernFile file, ITernDefinitionCollector collector) throws IOException, TernException {
        this.request(query, null, null, null, file, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, Node domNode, ITernFile file, ITernDefinitionCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchronize(doc, names, scriptPath, domNode, file);
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, ITernFile file, ITernTypeCollector collector) throws IOException, TernException {
        this.request(query, null, null, null, file, collector);
    }

    @Override
    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, Node domNode, ITernFile file, ITernTypeCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchronize(doc, names, scriptPath, domNode, file);
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, ITernFile file, ITernLintCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchronize(doc, null, null, null, file);
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public void request(TernQuery query, ITernLintCollector collector) throws IOException, TernException {
        this.request(query, null, collector);
    }

    @Override
    public void request(TernGuessTypesQuery query, ITernFile file, ITernGuessTypesCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchronize(doc, null, null, null, file);
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    @Override
    public ITernRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(ITernRepository repository) {
        this.repository = repository;
    }

    public boolean isDirty() {
        return !this.toString().equals(this.lastTernProjectFileContent);
    }
}

