/*
 * Decompiled with CFR 0.152.
 */
package tern.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tern.TernException;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.utils.TernModuleHelper;

public class TernRepository
implements ITernRepository {
    private static final String DEFS_FOLDER = "defs";
    private static final String PLUGIN_FOLDER = "plugin";
    private static final String NODE_MODULES_FOLDER = "node_modules";
    private final String name;
    private File ternBaseDir;
    private final boolean defaultRepository;
    private Map<String, ITernModule> modules;
    private Map<String, ITernModule> modulesByOrigin;
    private ITernPlugin[] linters;

    public TernRepository(String name, File ternBaseDir) {
        this(name, ternBaseDir, false);
    }

    public TernRepository(String name, File ternFile, boolean defaultRepository) {
        this.name = name;
        this.ternBaseDir = ternFile;
        this.defaultRepository = defaultRepository;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITernModule[] getModules() throws TernException {
        this.intializeIfNeeded();
        return this.modules.values().toArray(ITernModule.EMPTY_MODULE);
    }

    @Override
    public ITernModule getModule(String name) {
        try {
            this.intializeIfNeeded();
            return this.modules.get(name);
        }
        catch (TernException ternException) {
            return null;
        }
    }

    @Override
    public ITernModule getModuleByOrigin(String origin) {
        try {
            this.intializeIfNeeded();
            return this.modulesByOrigin.get(origin);
        }
        catch (TernException ternException) {
            return null;
        }
    }

    private void intializeIfNeeded() throws TernException {
        if (this.modules == null) {
            HashMap<String, ITernModule> modules = new HashMap<String, ITernModule>();
            HashMap<String, ITernModule> modulesByOrigin = new HashMap<String, ITernModule>();
            this.loadModules(modules, modulesByOrigin);
            this.modules = modules;
            this.modulesByOrigin = modulesByOrigin;
            this.linters = this.searchLinters(modules.values());
        }
    }

    private ITernPlugin[] searchLinters(Collection<ITernModule> values) {
        ArrayList<ITernPlugin> linters = new ArrayList<ITernPlugin>();
        for (ITernModule module : values) {
            if (module.getModuleType() != ModuleType.Plugin || !((ITernPlugin)module).isLinter()) continue;
            linters.add((ITernPlugin)module);
        }
        return linters.toArray(ITernPlugin.EMPTY_PLUGIN);
    }

    private void loadModules(Map<String, ITernModule> modules, Map<String, ITernModule> modulesByOrigin) throws TernException {
        this.loadModules(modules, modulesByOrigin, DEFS_FOLDER);
        this.loadModules(modules, modulesByOrigin, PLUGIN_FOLDER);
        this.loadModules(modules, modulesByOrigin, NODE_MODULES_FOLDER);
    }

    private void loadModules(Map<String, ITernModule> modules, Map<String, ITernModule> modulesByOrigin, String dir) throws TernException {
        File baseDir = new File(this.getTernBaseDir(), dir);
        if (baseDir.exists()) {
            File[] files = baseDir.listFiles();
            File file = null;
            ITernModule module = null;
            int i = 0;
            while (i < files.length) {
                file = files[i];
                module = TernModuleHelper.getModule(file.getName());
                if (module != null) {
                    modules.put(module.getName(), module);
                    modulesByOrigin.put(module.getOrigin(), module);
                }
                ++i;
            }
        }
    }

    @Override
    public void refresh() {
        this.modules = null;
    }

    @Override
    public File getTernBaseDir() {
        return this.ternBaseDir;
    }

    @Override
    public String getTernBaseDirAsString() {
        return TernModuleHelper.getPath(this.getTernBaseDir());
    }

    @Override
    public void setTernBaseDir(File ternBaseDir) {
        this.ternBaseDir = ternBaseDir;
    }

    @Override
    public boolean isDefault() {
        return this.defaultRepository;
    }

    @Override
    public File getFile(ITernModule module) {
        String fileName = TernModuleHelper.getFileName(module);
        File moduleFile = null;
        switch (module.getModuleType()) {
            case Plugin: 
            case Configurable: {
                moduleFile = new File(this.ternBaseDir, PLUGIN_FOLDER + '/' + fileName);
                break;
            }
            case Def: {
                moduleFile = new File(this.ternBaseDir, DEFS_FOLDER + '/' + fileName);
            }
        }
        if (moduleFile.exists()) {
            return moduleFile;
        }
        moduleFile = new File(this.ternBaseDir, NODE_MODULES_FOLDER + '/' + "tern-" + module.getName() + '/' + fileName);
        if (moduleFile.exists()) {
            return moduleFile;
        }
        return null;
    }

    @Override
    public ITernPlugin[] getLinters() {
        try {
            this.intializeIfNeeded();
        }
        catch (TernException e) {
            e.printStackTrace();
            return ITernPlugin.EMPTY_PLUGIN;
        }
        return this.linters;
    }
}

