/*
 * Decompiled with CFR 0.152.
 */
package tern.metadata;

import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import tern.metadata.TernModuleMetadata;

public class TernModuleMetadataManager {
    private final Map<String, TernModuleMetadata> metadatas = new HashMap<String, TernModuleMetadata>();
    private File metadataTernBaseDir;
    private static final TernModuleMetadataManager INSTANCE = new TernModuleMetadataManager();

    public static TernModuleMetadataManager getInstance() {
        return INSTANCE;
    }

    public TernModuleMetadata getMetadata(String moduleName) {
        this.initializeIfNeeded();
        return this.metadatas.get(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNeeded() {
        if (this.metadatas.size() == 0 && this.metadataTernBaseDir != null) {
            Map<String, TernModuleMetadata> map = this.metadatas;
            synchronized (map) {
                File metadataFile;
                if (this.metadatas.size() == 0 && (metadataFile = new File(this.metadataTernBaseDir, "metadata")).exists()) {
                    File[] files = metadataFile.listFiles();
                    File file = null;
                    JsonObject json = null;
                    int i = 0;
                    while (i < files.length) {
                        file = files[i];
                        if (file.isFile() && file.getName().endsWith(".metadata.json")) {
                            try {
                                json = JsonObject.readFrom((Reader)new FileReader(file));
                                TernModuleMetadata metadata = new TernModuleMetadata(json, file);
                                this.metadatas.put(metadata.getName(), metadata);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void init(File metadataTernBaseDir) {
        this.metadataTernBaseDir = metadataTernBaseDir;
    }
}

