/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import tern.angular.AngularType;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.Module;
import tern.utils.StringUtils;

class SAXModuleHandler
extends DefaultHandler {
    private Module module;
    private StringBuilder description = null;
    private Directive directive;
    private DirectiveParameter directiveParameter;

    SAXModuleHandler() {
    }

    public Module load(InputStream in) throws IOException, SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.parse(new InputSource(in));
        return this.module;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("module".equals(name)) {
            String moduleName = attributes.getValue("name");
            this.module = new Module(moduleName);
        } else if ("directive".equals(name)) {
            String directiveName = attributes.getValue("name");
            String url = attributes.getValue("url");
            AngularType directiveType = AngularType.get(attributes.getValue("type"));
            ArrayList<String> tagsName = new ArrayList<String>();
            String tags = attributes.getValue("tags");
            if (!StringUtils.isEmpty(tags)) {
                String[] names = tags.split(",");
                String tagName = null;
                int i = 0;
                while (i < names.length) {
                    tagName = names[i].trim();
                    if (tagName.length() > 0) {
                        tagsName.add(tagName);
                    }
                    ++i;
                }
            }
            String restrict = attributes.getValue("restrict");
            DirectiveValue directiveValue = DirectiveValue.get(attributes.getValue("value"));
            this.directive = new Directive(directiveName, directiveType, url, tagsName, restrict, directiveValue, this.module, false);
        } else if ("description".equals(name)) {
            this.description = new StringBuilder();
        } else if ("parameter".equals(name)) {
            String parameterName = attributes.getValue("name");
            boolean optional = StringUtils.asBoolean(attributes.getValue("optional"), false);
            this.directiveParameter = new DirectiveParameter(parameterName, optional, this.directive);
            this.directive.addParameter(this.directiveParameter);
            this.description = new StringBuilder();
        }
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("directive".equals(name)) {
            this.directive = null;
        } else if ("parameter".equals(name)) {
            if (this.description != null) {
                this.directiveParameter.setDescription(this.description.toString());
            }
            this.directiveParameter = null;
        } else if ("description".equals(name)) {
            this.directive.setDescription(this.description.toString());
            this.description = null;
        }
        super.endElement(uri, localName, name);
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.description != null) {
            this.description.append(String.valueOf(ch, start, length));
        }
        super.characters(ch, start, length);
    }
}

