/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jsf.template;

import org.jboss.tools.jsf.vpe.jsf.template.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsfSelectOneRadioTemplate
extends VpeAbstractTemplate {
    private static final String VAL_PAGE_DIRECTION = "pageDirection";
    private static final String ATTR_LAYOUT = "layout";
    private static final String ATTR_BORDER = "border";
    private static final String ATTR_DISABLED_CLASS = "disabledClass";
    private static final String ATTR_ENABLED_CLASS = "enabledClass";
    private static final String ATTR_STYLE_CLASS = "styleClass";
    private static final String ATTR_DIR_RIGHT_TO_LEFT = "rtl";
    private static final String ATTR_DIR_LEFT_TO_RIGHT = "ltr";
    private static final String ATTR_DISABLED_VALUE = "disabled";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        NodeList children;
        int count;
        Element sourceElement = (Element)sourceNode;
        boolean layoutHorizontal = true;
        String layout = sourceElement.getAttribute(ATTR_LAYOUT);
        layoutHorizontal = !VAL_PAGE_DIRECTION.equalsIgnoreCase(layout);
        nsIDOMElement div = visualDocument.createElement("div");
        nsIDOMElement visualTable = visualDocument.createElement("table");
        div.appendChild((nsIDOMNode)visualTable);
        VpeCreationData creatorInfo = new VpeCreationData((nsIDOMNode)div);
        visualTable.setAttribute("class", ComponentUtil.getAttribute(sourceElement, ATTR_STYLE_CLASS));
        visualTable.setAttribute("style", ComponentUtil.getAttribute(sourceElement, "style"));
        if (sourceElement.hasAttribute(ATTR_BORDER)) {
            String border = sourceElement.getAttribute(ATTR_BORDER);
            visualTable.setAttribute(ATTR_BORDER, border);
        }
        int n = count = (children = sourceNode.getChildNodes()) != null ? children.getLength() : 0;
        if (count > 0) {
            Node[] sourceChildren = new Node[count];
            int childrenCount = 0;
            int i = 0;
            while (i < count) {
                Node node = children.item(i);
                short type = node.getNodeType();
                if (type == 1 || type == 3 && node.getNodeValue().trim().length() > 0) {
                    sourceChildren[childrenCount] = node;
                    ++childrenCount;
                }
                ++i;
            }
            if (childrenCount > 0) {
                int rowLength;
                int rowCount;
                int tableSize = childrenCount;
                if (layoutHorizontal) {
                    rowCount = (childrenCount + tableSize - 1) / tableSize;
                    rowLength = tableSize;
                } else {
                    rowCount = tableSize;
                    rowLength = (childrenCount + tableSize - 1) / tableSize;
                }
                int i2 = 0;
                while (i2 < rowCount) {
                    nsIDOMElement visualRow = visualDocument.createElement("tr");
                    int j = 0;
                    while (j < rowLength) {
                        int sourceIndex;
                        nsIDOMElement visualCell = visualDocument.createElement("td");
                        visualRow.appendChild((nsIDOMNode)visualCell);
                        int n2 = sourceIndex = layoutHorizontal ? rowLength * i2 + j : rowCount * j + i2;
                        if (sourceIndex < childrenCount) {
                            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualCell);
                            childrenInfo.addSourceChild(sourceChildren[sourceIndex]);
                            creatorInfo.addChildrenInfo(childrenInfo);
                        }
                        ++j;
                    }
                    visualTable.appendChild((nsIDOMNode)visualRow);
                    ++i2;
                }
            }
        }
        return creatorInfo;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        if (data.getNode() != null) {
            this.applyChildAttributes((Element)sourceNode, data.getNode());
        }
    }

    private void applyChildAttributes(Element sourceElement, nsIDOMNode node) {
        boolean disabled = false;
        try {
            nsIDOMNodeList list = node.getChildNodes();
            nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
            disabled = ComponentUtil.string2boolean(ComponentUtil.getAttribute(sourceElement, ATTR_DISABLED_VALUE));
            if (node.getNodeName().equalsIgnoreCase("input")) {
                element.setAttribute("dir", ComponentUtil.getAttribute(sourceElement, "dir").trim().equalsIgnoreCase(ATTR_DIR_RIGHT_TO_LEFT) ? ATTR_DIR_RIGHT_TO_LEFT : (ComponentUtil.getAttribute(sourceElement, "dir").trim().equalsIgnoreCase(ATTR_DIR_LEFT_TO_RIGHT) ? ATTR_DIR_LEFT_TO_RIGHT : ""));
                element.setAttribute("size", ComponentUtil.getAttribute(sourceElement, "size"));
                if (disabled || ComponentUtil.string2boolean(ComponentUtil.getAttribute(element, "itemDisabled"))) {
                    element.setAttribute(ATTR_DISABLED_VALUE, ATTR_DISABLED_VALUE);
                }
            }
            if (node.getNodeName().equalsIgnoreCase("label")) {
                element.setAttribute("class", disabled || ComponentUtil.string2boolean(ComponentUtil.getAttribute(element, "itemDisabled")) ? ComponentUtil.getAttribute(sourceElement, ATTR_DISABLED_CLASS) : ComponentUtil.getAttribute(sourceElement, ATTR_ENABLED_CLASS));
            }
            if (node.getNodeName().equalsIgnoreCase("table")) {
                element.setAttribute("style", ComponentUtil.getAttribute(sourceElement, "style"));
            }
            int i = 0;
            while ((long)i < list.getLength()) {
                this.applyChildAttributes(sourceElement, list.item((long)i));
                ++i;
            }
        }
        catch (XPCOMException xPCOMException) {
            return;
        }
    }
}

