/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jsf.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentUtil {
    public static String getAttribute(Element sourceElement, String attributeName) {
        String attribute = sourceElement.getAttribute(attributeName);
        if (attribute == null) {
            attribute = "";
        }
        return attribute;
    }

    public static String getAttribute(nsIDOMElement sourceElement, String attributeName) {
        String attribute = sourceElement.getAttribute(attributeName);
        if (attribute == null) {
            attribute = "";
        }
        return attribute;
    }

    public static boolean isDisabled(Element element) {
        return ComponentUtil.string2boolean(ComponentUtil.getAttribute(element, "disabled"));
    }

    public static void setDisabled(nsIDOMElement element, boolean disabled) {
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    public static void copyDisabled(Element sourceElement, nsIDOMElement targetElement) {
        boolean disabled = ComponentUtil.isDisabled(sourceElement);
        ComponentUtil.setDisabled(targetElement, disabled);
    }

    public static boolean string2boolean(String str) {
        return Boolean.parseBoolean(str);
    }

    public static String getBundleValue(VpePageContext pageContext, Attr attr) {
        return ComponentUtil.getBundleValue(pageContext, attr.getNodeValue());
    }

    public static String getBundleValue(VpePageContext pageContext, String value) {
        BundleMap bundle = pageContext.getBundle();
        return bundle.getBundleValue(value);
    }

    public static List<Node> getChildren(Element sourceElement) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodeList = sourceElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            children.add(child);
            ++i;
        }
        return children;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotBlank(String value) {
        return !ComponentUtil.isBlank(value);
    }

    public static Locale createLocale(String localeString) {
        Locale newLocale = null;
        newLocale = localeString != null ? (localeString.length() == 2 ? new Locale(localeString) : (localeString.length() == 5 && localeString.indexOf("_") == 2 ? new Locale(localeString.substring(0, 2), localeString.substring(3)) : new Locale(""))) : new Locale("");
        return newLocale;
    }
}

