/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.LineRoot;

public class NestedLine
extends LineBox {
    InlineFlow owner;
    private LineRoot root;

    NestedLine(InlineFlow owner) {
        this.owner = owner;
    }

    public boolean containsPoint(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getBaseline() - this.getAscentWithBorder() && y < this.getBaseline() + this.getDescentWithBorder();
    }

    int getAscentWithBorder() {
        return this.contentAscent + FlowUtilities.getBorderAscent(this.owner);
    }

    int getDescentWithBorder() {
        return this.contentDescent + FlowUtilities.getBorderDescent(this.owner);
    }

    public int getBaseline() {
        return this.root.getBaseline();
    }

    LineRoot getLineRoot() {
        return this.root;
    }

    public int getOuterAscent() {
        return this.contentAscent + FlowUtilities.getBorderAscentWithMargin(this.owner);
    }

    public int getOuterDescent() {
        return this.contentDescent + FlowUtilities.getBorderDescentWithMargin(this.owner);
    }

    void setLineRoot(LineRoot root) {
        this.root = root;
        int i = 0;
        while (i < this.fragments.size()) {
            ((FlowBox)this.fragments.get(i)).setLineRoot(root);
            ++i;
        }
    }

    public void setLineTop(int top) {
        throw new RuntimeException("not supported");
    }
}

