/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.playground.easymport.maven;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.jboss.tools.playground.easymport.maven.Activator;

public class MavenProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return this.shouldBeAnEclipseProject((IContainer)project, monitor);
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> excludedDirectories, IProgressMonitor monitor) {
        ResolverConfiguration configuration = new ResolverConfiguration();
        configuration.setResolveWorkspaceProjects(true);
        MavenPlugin.getProjectConfigurationManager();
        try {
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
                newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
                description.setNatureIds(newNatures);
                project.setDescription(description, monitor);
            }
            UpdateMavenConfigurationJob.getInstance().addProjectToProcess(project);
            if (UpdateMavenConfigurationJob.getInstance().getState() == 0) {
                UpdateMavenConfigurationJob.getInstance().schedule();
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.maven", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        IFile pomFile = container.getFile((IPath)new Path("pom.xml"));
        return pomFile.exists();
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        res.add(project.getFolder("src"));
        res.add(project.getFolder("target"));
        return res;
    }

    private static class UpdateMavenConfigurationJob
    extends Job {
        private static UpdateMavenConfigurationJob INSTANCE;
        private Set<IProject> toProcess = new HashSet<IProject>();

        public static synchronized UpdateMavenConfigurationJob getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new UpdateMavenConfigurationJob();
            }
            return INSTANCE;
        }

        private UpdateMavenConfigurationJob() {
            super("Update Maven projects configuration");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectToProcess(IProject project) {
            Set<IProject> set = this.toProcess;
            synchronized (set) {
                this.toProcess.add(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            HashSet<IProject> toProcessNow = new HashSet<IProject>();
            while (true) {
                Set<IProject> set = this.toProcess;
                synchronized (set) {
                    if (this.toProcess.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    for (IProject project : this.toProcess) {
                        toProcessNow.add(project);
                    }
                    this.toProcess.removeAll(toProcessNow);
                }
                new UpdateMavenProjectJob(toProcessNow.toArray(new IProject[toProcessNow.size()]), false, false, true, false, false).run(monitor);
            }
        }
    }
}

