/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserFactory;

public class Var {
    IFile file;
    String name;
    String value;
    ELExpression elToken;
    String resolvedValue;
    ELExpression resolvedElToken;
    int declOffset;
    int declLength;
    ELParserFactory factory;
    Region region;

    public Var(ELParserFactory factory, String name, String value, int declOffset, int declLength) {
        this.factory = factory;
        this.name = name;
        this.value = value;
        this.elToken = this.parseEl(value);
        this.declOffset = declOffset;
        this.declLength = declLength;
    }

    ELExpression parseEl(String el) {
        if (el.length() > 3 && el.startsWith("#{") && el.endsWith("}")) {
            ELParser parser = this.factory.createParser();
            ELModel model = parser.parse(el);
            if (model == null || model.getSyntaxErrors().size() > 0) {
                return null;
            }
            List<ELInstance> is = model.getInstances();
            if (is.size() == 0) {
                return null;
            }
            return is.get(0).getExpression();
        }
        return null;
    }

    public void resolveValue(String newEl) {
        this.resolvedValue = newEl;
        this.resolvedElToken = this.parseEl(newEl);
    }

    public ELExpression getElToken() {
        return this.elToken;
    }

    public ELExpression getResolvedElToken() {
        return this.resolvedElToken;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getResolvedValue() {
        return this.resolvedValue;
    }

    public int getDeclarationOffset() {
        return this.declOffset;
    }

    public int getDeclarationLength() {
        return this.declLength;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Var) {
            Var compare = (Var)obj;
            String str = this.getName();
            if (str != null ? !str.equals(compare.getName()) : compare.getName() != null) {
                return false;
            }
            str = this.getValue();
            return str != null ? str.equals(compare.getValue()) : compare.getValue() == null;
        }
        return false;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }
}

