/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.resolver.ELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;

public class JavaMemberELSegmentImpl
extends ELSegmentImpl
implements JavaMemberELSegment {
    protected IJavaElement element;
    protected Set<IJavaElement> allElements;
    protected TypeInfoCollector.MemberInfo memberInfo;
    protected boolean hasSetter;
    protected boolean hasGetter;
    protected Map<String, TypeInfoCollector.MethodInfo> unpairedGettersOrSetters;

    public JavaMemberELSegmentImpl(LexicalToken token) {
        super(token);
    }

    @Override
    public IJavaElement getJavaElement() {
        if (this.element == null && this.memberInfo != null) {
            this.element = this.memberInfo.getJavaElement();
        }
        return this.element;
    }

    @Override
    public TypeInfoCollector.MemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    @Override
    public boolean hasGetter() {
        return this.hasGetter;
    }

    @Override
    public boolean hasSetter() {
        return this.hasSetter;
    }

    public void setElement(IJavaElement element) {
        this.element = element;
        try {
            this.setResource(element.getUnderlyingResource());
        }
        catch (JavaModelException e) {
            ELCorePlugin.getDefault().logError(e);
        }
    }

    public void addJavaElement(IJavaElement element) {
        if (this.allElements == null) {
            this.allElements = new HashSet<IJavaElement>();
        }
        this.allElements.add(element);
    }

    @Override
    public IJavaElement[] getAllJavaElements() {
        if (this.allElements == null || this.allElements.size() == 0) {
            return new IJavaElement[0];
        }
        return this.allElements.toArray(new IJavaElement[this.allElements.size()]);
    }

    public boolean isHasSetter() {
        return this.hasSetter;
    }

    public void setHasSetter(boolean hasSetter) {
        this.hasSetter = hasSetter;
    }

    public boolean isHasGetter() {
        return this.hasGetter;
    }

    public void setHasGetter(boolean hasGetter) {
        this.hasGetter = hasGetter;
    }

    public void setMemberInfo(TypeInfoCollector.MemberInfo memberInfo) {
        this.memberInfo = memberInfo;
        if (memberInfo != null && memberInfo.getJavaElement() != null) {
            this.setElement(memberInfo.getJavaElement());
        }
    }

    public Map<String, TypeInfoCollector.MethodInfo> getUnpairedGettersOrSetters() {
        if (this.unpairedGettersOrSetters == null) {
            this.unpairedGettersOrSetters = new HashMap<String, TypeInfoCollector.MethodInfo>();
        }
        return this.unpairedGettersOrSetters;
    }

    public void clearUnpairedGettersOrSetters() {
        this.getUnpairedGettersOrSetters().clear();
    }

    @Override
    public IOpenableReference[] getOpenable() {
        IOpenableReference[] os = super.getOpenable();
        if (this.getJavaElement() != null && this.getJavaElement().exists()) {
            IOpenableReference openable = new IOpenableReference(){

                @Override
                public boolean open() {
                    try {
                        return JavaUI.openInEditor((IJavaElement)JavaMemberELSegmentImpl.this.getJavaElement()) != null;
                    }
                    catch (PartInitException e) {
                        CommonPlugin.getDefault().logError((Throwable)e);
                    }
                    catch (JavaModelException e) {
                        CommonPlugin.getDefault().logError((Throwable)e);
                    }
                    return false;
                }

                @Override
                public String getLabel() {
                    IJavaElement javaElement = JavaMemberELSegmentImpl.this.getJavaElement();
                    String name = "";
                    IType type = null;
                    if (javaElement instanceof IType) {
                        name = javaElement.getElementName();
                        type = (IType)javaElement;
                    } else if (javaElement instanceof IMethod) {
                        type = ((IMethod)javaElement).getDeclaringType();
                        name = String.valueOf(type.getElementName()) + "." + javaElement.getElementName() + "()";
                    } else if (javaElement instanceof IField) {
                        type = ((IField)javaElement).getDeclaringType();
                        name = String.valueOf(type.getElementName()) + "." + javaElement.getElementName();
                    }
                    if (type != null) {
                        name = String.valueOf(name) + " - " + type.getPackageFragment().getElementName();
                    }
                    return MessageFormat.format(ElCoreMessages.Open, name);
                }

                @Override
                public Image getImage() {
                    return null;
                }
            };
            if (os.length > 0) {
                IOpenableReference[] os1 = new IOpenableReference[os.length + 1];
                System.arraycopy(os, 0, os1, 0, os.length);
                os1[os.length] = openable;
                return os1;
            }
            return new IOpenableReference[]{openable};
        }
        return os;
    }
}

