/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.text.ITextSourceReference;

public class ELSegmentImpl
implements ELSegment {
    protected IResource resource;
    protected ITextSourceReference sourceReference;
    protected LexicalToken token;
    protected boolean resolved = false;
    protected boolean validatable = true;
    protected List<IVariable> variables = new ArrayList<IVariable>();
    protected List<Var> vars = new ArrayList<Var>();

    public ELSegmentImpl(LexicalToken token) {
        this.token = token;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public ITextSourceReference getSourceReference() {
        if (this.sourceReference == null) {
            this.sourceReference = new ITextSourceReference(){

                public int getStartPosition() {
                    return ELSegmentImpl.this.token.getStart();
                }

                public int getLength() {
                    return ELSegmentImpl.this.token.getLength();
                }

                public IResource getResource() {
                    return ELSegmentImpl.this.resource;
                }
            };
        }
        return this.sourceReference;
    }

    @Override
    public IOpenableReference[] getOpenable() {
        if (!this.vars.isEmpty()) {
            ArrayList<VarOpenable> rs = new ArrayList<VarOpenable>();
            for (Var var : this.vars) {
                rs.add(new VarOpenable(var));
            }
            return rs.toArray(new VarOpenable[0]);
        }
        return new IOpenableReference[0];
    }

    @Override
    public LexicalToken getToken() {
        return this.token;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setSourceReference(ITextSourceReference sourceReference) {
        this.sourceReference = sourceReference;
    }

    public void setToken(LexicalToken token) {
        this.token = token;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public List<IVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<IVariable> variables) {
        this.variables = variables;
    }

    public String toString() {
        return this.token != null ? String.valueOf(this.token.getText()) + "(" + this.resolved + ")" : super.toString();
    }

    @Override
    public boolean isValidatable() {
        return this.validatable;
    }

    public void setValidatable(boolean validatable) {
        this.validatable = validatable;
    }

    public void setVars(List<Var> vars) {
        this.vars = vars;
    }

    public Var getVar() {
        return this.vars.isEmpty() ? null : this.vars.iterator().next();
    }

    public static class VarOpenable
    implements IOpenableReference {
        Var var;

        VarOpenable(Var var) {
            this.var = var;
        }

        @Override
        public boolean open() {
            IEditorPart part = null;
            IWorkbenchWindow window = ELCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return false;
            }
            IWorkbenchPage page = window.getActivePage();
            try {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.var.getFile());
            }
            catch (PartInitException e) {
                ELCorePlugin.getDefault().logError(e);
            }
            if (part != null) {
                part.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(this.var.getDeclarationOffset(), this.var.getDeclarationLength()));
            }
            return false;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(ElCoreMessages.OpenVarDefinition, this.var.getName(), this.var.getFile().getName());
        }

        public Var getVar() {
            return this.var;
        }

        @Override
        public Image getImage() {
            return null;
        }
    }
}

