/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.wizard.runtime;

import org.jboss.tools.common.verification.ui.vrules.wizard.VRuleTipFactory;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeItemWrapper;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;

public class RuntimeRuleSetWrapper
extends RuntimeItemWrapper {
    protected VRuleSet set;
    RuntimeItemWrapper[] children = new RuntimeItemWrapper[0];

    public RuntimeRuleSetWrapper(VRuleSet set) {
        this.set = set;
    }

    @Override
    public String getPresentation() {
        return this.set.getName();
    }

    @Override
    public Object getObject() {
        return this.set;
    }

    public void updateStatus() {
        if (this.children.length == 0) {
            return;
        }
        int min = 2;
        int max = 0;
        int i = 0;
        while (i < this.children.length) {
            int s = this.children[i].getStatus();
            if (s < min) {
                min = s;
            }
            if (s > max) {
                max = s;
            }
            ++i;
        }
        if (max == 2) {
            this.setStatus(2);
        } else if (min == 1) {
            this.setStatus(1);
        }
    }

    @Override
    public VRule[] getRules() {
        if (this.children == null) {
            return new VRule[0];
        }
        VRule[] rs = new VRule[this.children.length];
        int i = 0;
        while (i < rs.length) {
            VRule[] x = this.children[i].getRules();
            if (x.length > 0) {
                rs[i] = x[0];
            }
            ++i;
        }
        return rs;
    }

    @Override
    public String getTip() {
        return VRuleTipFactory.getRuleTip(this.set);
    }
}

