/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.wizard;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.composites.AbstractJREComposite;
import org.jboss.ide.eclipse.as.wtp.ui.composites.IJRECompositeListener;
import org.jboss.ide.eclipse.as.wtp.ui.composites.IRuntimeHomeCompositeListener;
import org.jboss.ide.eclipse.as.wtp.ui.composites.RuntimeHomeComposite;

public abstract class RuntimeWizardFragment
extends WizardFragment {
    protected IWizardHandle handle;
    protected boolean beenEntered = false;
    protected Label nameLabel;
    protected Label explanationLabel;
    protected Text nameText;
    protected AbstractJREComposite jreComposite;
    protected RuntimeHomeComposite homeDirComposite;
    protected Composite nameComposite;
    protected String originalName;
    protected String name;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.updateModels();
        this.createWidgets(main);
        IRuntime rt = this.getRuntimeFromTaskModel();
        if (rt != null) {
            this.fillWidgets(rt);
        }
        this.updateWizardHandle(parent);
        this.updatePage();
        return main;
    }

    protected void updateModels() {
    }

    protected IRuntime getRuntimeFromTaskModel() {
        IRuntime r = (IRuntime)this.getTaskModel().getObject("runtime");
        return r;
    }

    protected abstract void updateWizardHandle(Composite var1);

    protected void createWidgets(Composite main) {
        this.createExplanation(main);
        this.createNameComposite(main);
        this.createHomeComposite(main);
        this.createJREComposite(main);
    }

    protected void fillNameWidgets(IRuntime rt) {
        this.originalName = rt.getName();
        this.nameText.setText(this.originalName);
        this.name = this.originalName;
    }

    protected void fillHomeDir(IRuntime rt) {
        this.homeDirComposite.fillHomeDir(rt);
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void fillWidgets(IRuntime rt) {
        this.fillNameWidgets(rt);
        this.fillHomeDir(rt);
    }

    protected void createExplanation(Composite main) {
        this.explanationLabel = new Label(main, 64);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.explanationLabel.setLayoutData((Object)data);
        this.explanationLabel.setText(this.getExplanationText());
    }

    protected abstract String getExplanationText();

    protected void createNameComposite(Composite main) {
        this.nameComposite = new Composite(main, 0);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.explanationLabel, 10);
        this.nameComposite.setLayoutData((Object)cData);
        this.nameComposite.setLayout((Layout)new FormLayout());
        this.nameLabel = new Label(this.nameComposite, 0);
        this.nameLabel.setText(Messages.wf_NameLabel);
        this.nameText = new Text(this.nameComposite, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RuntimeWizardFragment.this.name = RuntimeWizardFragment.this.nameText.getText();
                RuntimeWizardFragment.this.updatePage();
            }
        });
        FormData nameLabelData = new FormData();
        nameLabelData.left = new FormAttachment(0, 0);
        this.nameLabel.setLayoutData((Object)nameLabelData);
        FormData nameTextData = new FormData();
        nameTextData.left = new FormAttachment(0, 5);
        nameTextData.right = new FormAttachment(100, -5);
        nameTextData.top = new FormAttachment((Control)this.nameLabel, 5);
        this.nameText.setLayoutData((Object)nameTextData);
    }

    protected void createHomeComposite(Composite main) {
        this.homeDirComposite = this.createHomeCompositeWidget(main);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.nameComposite, 10);
        this.homeDirComposite.setLayoutData(cData);
        this.homeDirComposite.setListener(new IRuntimeHomeCompositeListener(){

            @Override
            public void homeChanged() {
                RuntimeWizardFragment.this.updatePage();
            }
        });
    }

    protected abstract RuntimeHomeComposite createHomeCompositeWidget(Composite var1);

    protected void createJREComposite(Composite main) {
        this.jreComposite = this.createJRECompositeWidget(main);
        FormData cData = new FormData();
        cData.left = new FormAttachment(0, 5);
        cData.right = new FormAttachment(100, -5);
        cData.top = new FormAttachment((Control)this.homeDirComposite, 10);
        this.jreComposite.setLayoutData(cData);
        this.jreComposite.setListener(new IJRECompositeListener(){

            @Override
            public void vmChanged(AbstractJREComposite comp) {
                RuntimeWizardFragment.this.updatePage();
            }
        });
    }

    protected abstract AbstractJREComposite createJRECompositeWidget(Composite var1);

    protected void updatePage() {
        this.updateDependentWidgets();
        this.saveDetailsInRuntime();
        this.updateErrorMessage();
    }

    protected void updateDependentWidgets() {
    }

    protected void updateErrorMessage() {
        if (!this.beenEntered) {
            return;
        }
        String error = this.getErrorString();
        if (error == null) {
            String warn = this.getWarningString();
            if (warn != null) {
                this.handle.setMessage(warn, 2);
            } else {
                this.handle.setMessage(null, 0);
            }
        } else {
            this.handle.setMessage(error, 3);
        }
    }

    protected String getErrorString() {
        if (this.nameText == null) {
            return null;
        }
        if (this.getRuntime(this.name) != null) {
            return Messages.rwf_NameInUse;
        }
        if (this.jreComposite != null) {
            IExecutionEnvironment selectedEnv = this.jreComposite.getSelectedExecutionEnvironment();
            IVMInstall install = this.jreComposite.getSelectedVM();
            if (install == null && selectedEnv != null && selectedEnv.getCompatibleVMs().length == 0) {
                return NLS.bind((String)Messages.rwf_noValidJRE, (Object)selectedEnv.getId());
            }
        }
        if (this.name == null || this.name.equals("")) {
            return Messages.rwf_nameTextBlank;
        }
        if (!this.homeDirComposite.isHomeValid()) {
            return Messages.rwf_jboss7homeNotValid;
        }
        return null;
    }

    protected String getWarningString() {
        String homeVersionWarning = this.getHomeVersionWarning();
        if (homeVersionWarning != null) {
            return homeVersionWarning;
        }
        if (!this.jreComposite.selectedVMisCompatible()) {
            return Messages.rwf_incompatibleJRE;
        }
        return null;
    }

    protected String getVersionString(File loc) {
        String version = new ServerBeanLoader(loc).getFullServerVersion();
        return version == null ? "UNKNOWN" : version;
    }

    protected String getHomeVersionWarning() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        File loc = new File(homeDir);
        String serverId = new ServerBeanLoader(loc).getServerAdapterId();
        IServerType st = serverId == null ? null : ServerCore.findServerType((String)serverId);
        String rtId = RuntimeUtils.getRuntimeTypeId((IServerType)st);
        IRuntime adapterRt = this.getRuntimeFromTaskModel();
        String adapterRuntimeId = adapterRt.getRuntimeType().getId();
        if (!adapterRuntimeId.equals(rtId)) {
            return NLS.bind((String)Messages.rwf_homeIncorrectVersionError, (Object)adapterRt.getRuntimeType().getVersion(), (Object)this.getVersionString(loc));
        }
        return null;
    }

    protected static File getDirectory(File startingDirectory, Shell shell) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public void enter() {
        this.beenEntered = true;
    }

    public void exit() {
        this.saveDetailsInRuntime();
    }

    protected void saveDetailsInRuntime() {
        IRuntime r = this.getRuntimeFromTaskModel();
        IRuntimeWorkingCopy runtimeWC = r.isWorkingCopy() ? (IRuntimeWorkingCopy)r : r.createWorkingCopy();
        this.saveDetailsInRuntime(runtimeWC);
    }

    protected void saveDetailsInRuntime(IRuntimeWorkingCopy wc) {
        this.saveBasicDetailsInRuntime(wc);
    }

    protected void saveBasicDetailsInRuntime(IRuntimeWorkingCopy runtimeWC) {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        if (this.name != null) {
            runtimeWC.setName(this.name);
        }
        if (homeDir != null) {
            runtimeWC.setLocation((IPath)new Path(homeDir));
        }
        this.saveJreInRuntime(runtimeWC);
    }

    protected abstract void saveJreInRuntime(IRuntimeWorkingCopy var1);

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        IRuntime rt = this.getRuntimeFromTaskModel();
        if (rt instanceof IRuntimeWorkingCopy) {
            IRuntimeWorkingCopy r = (IRuntimeWorkingCopy)rt;
            IRuntime saved = r.save(false, (IProgressMonitor)new NullProgressMonitor());
            this.getTaskModel().putObject("runtime", (Object)saved);
            this.saveRuntimeLocationInPreferences(saved);
        }
    }

    protected abstract void saveRuntimeLocationInPreferences(IRuntime var1);

    public boolean isComplete() {
        return this.beenEntered && this.getErrorString() == null;
    }

    public boolean hasComposite() {
        return true;
    }

    protected IRuntime getRuntime(String runtimeName) {
        if (runtimeName.equals(this.originalName)) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i].getName().equals(runtimeName)) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public IRuntimeType getRuntimeType() {
        IRuntime r = this.getRuntimeFromTaskModel();
        return r.getRuntimeType();
    }
}

